/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common;

import lombok.Generated;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.type.PlatformType;
import me.whereareiam.socialismus.api.type.PluginType;
import me.whereareiam.socialismus.api.type.Version;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class IntegrityChecker {
    private final PlatformInteractor interactor;

    public boolean checkIntegrity() {
        PluginType pluginType = PluginType.getExactType();
        Version currentVersion = this.interactor.getServerVersion();
        return switch (pluginType) {
            case PluginType.PAPER -> this.checkPaperIntegrity(currentVersion);
            case PluginType.BUKKIT -> this.checkBukkitIntegrity(currentVersion);
            default -> false;
        };
    }

    private boolean checkPaperIntegrity(Version currentVersion) {
        if (Version.isLowerThan(currentVersion, Version.V_1_20_1)) {
            Logger.severe("You can't use PAPER version of the plugin, because it is made for versions greater than or equal to 1.20.1 and your version is " + String.valueOf((Object)currentVersion), new Object[0]);
            return false;
        }
        return Version.isHigherThan(currentVersion, Version.V_1_20_1);
    }

    private boolean checkBukkitIntegrity(Version currentVersion) {
        if (currentVersion.isAtLeast(Version.V_1_20_1) && (PlatformType.getType() == PlatformType.FOLIA || PlatformType.getType() == PlatformType.PAPER)) {
            Logger.warn("It seems that you are using a version of the plugin that is not recommended for this platform. Please consider using the PAPER version of the plugin with Java 21+, it will be more stable and performant.", new Object[0]);
            return true;
        }
        return currentVersion.isAtLeast(Version.V_1_16);
    }

    @Inject
    @Generated
    public IntegrityChecker(PlatformInteractor interactor) {
        this.interactor = interactor;
    }
}

