/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import me.whereareiam.socialismus.api.AnsiColor;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.scheduler.PeriodicalRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.RunnableTask;
import me.whereareiam.socialismus.api.output.Scheduler;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class Updater {
    private final Settings.Updater updater;
    private final Scheduler scheduler;
    private final Gson gson = new Gson();

    @Inject
    public Updater(Settings settings, Scheduler scheduler) {
        this.updater = settings.getUpdater();
        this.scheduler = scheduler;
    }

    public void start() {
        if (!this.updater.isCheckForUpdates()) {
            return;
        }
        if (this.updater.getInterval() <= 0) {
            return;
        }
        this.scheduler.schedule((PeriodicalRunnableTask)((PeriodicalRunnableTask.PeriodicalRunnableTaskBuilder)((PeriodicalRunnableTask.PeriodicalRunnableTaskBuilder)((PeriodicalRunnableTask.PeriodicalRunnableTaskBuilder)((RunnableTask.RunnableTaskBuilder)PeriodicalRunnableTask.builder().period((long)this.updater.getInterval() * 60L * 60L * 1000L)).runnable(this::checkForUpdate)).module("main")).delay(0L)).build(), true);
    }

    private void checkForUpdate() {
        String version = "DEV";
        if (this.updater.isWarnAboutDevBuilds() && version.equals("DEV")) {
            Logger.info("You are using a " + String.valueOf((Object)AnsiColor.ORANGE) + "local build" + String.valueOf((Object)AnsiColor.RESET) + " of Socialismus.", new Object[0]);
            return;
        }
        if (this.updater.isWarnAboutDevBuilds() && version.startsWith("DEV-")) {
            this.checkDevBuild(version);
            return;
        }
        if (this.updater.isWarnAboutUpdates()) {
            this.checkNonDevBuild(version);
        }
    }

    private void checkDevBuild(String version) {
        JsonElement jsonElement;
        String commit;
        String currentCommit = version.split("-")[1].toLowerCase();
        String response = this.request("https://api.github.com/repos/whereareiam/Socialismus/commits");
        JsonArray jsonArray = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        int commitCount = 0;
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext() && !(commit = (jsonElement = (JsonElement)iterator.next()).getAsJsonObject().get("sha").getAsString()).startsWith(currentCommit)) {
            ++commitCount;
        }
        if (commitCount == 0) {
            Logger.info("You are using a dev build of the plugin.", new Object[0]);
        } else {
            Logger.warn("You are using a dev build of the plugin, but you are behind by " + commitCount + " commits.", new Object[0]);
        }
    }

    private void checkNonDevBuild(String version) {
        String response = this.request("https://api.modrinth.com/v2/project/Socialismus/version");
        JsonArray jsonArray = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        String latestVersion = jsonArray.get(0).getAsJsonObject().get("version_number").getAsString();
        if (version.matches("\\d+\\.\\d+\\.\\d+")) {
            String[] latestVersionParts = latestVersion.split("\\.");
            String[] versionParts = version.split("\\.");
            int versionDifference = 0;
            for (int i = 0; i < 3; ++i) {
                versionDifference += Integer.parseInt(latestVersionParts[i]) - Integer.parseInt(versionParts[i]);
            }
            if (versionDifference == 0) {
                Logger.info("Your version is up to date.", new Object[0]);
            } else {
                Logger.warn("Your version is behind by " + versionDifference + " versions [Current: " + version + ", Latest: " + latestVersion + "]", new Object[0]);
                Logger.warn("Download the latest version at https://modrinth.com/plugin/socialismus/versions", new Object[0]);
            }
        }
    }

    private String request(String urlString) {
        try {
            String line;
            URL url = URI.create(urlString).toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            reader.close();
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

