/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat;

import me.whereareiam.socialismus.api.input.chat.ChatCoordinationService;
import me.whereareiam.socialismus.api.input.container.ChatHistoryContainerService;
import me.whereareiam.socialismus.api.input.event.chat.ChatBroadcastEvent;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.type.PlatformType;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.common.chat.ChatBroadcaster;
import me.whereareiam.socialismus.common.chat.processor.ChatMessageProcessor;
import me.whereareiam.socialismus.common.chat.processor.FormattedChatMessageProcessor;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ChatCoordinator
implements ChatCoordinationService {
    private final ChatMessageProcessor chatMessageProcessor;
    private final FormattedChatMessageProcessor formattedChatMessageProcessor;
    private final ChatBroadcaster chatBroadcaster;
    private final ChatHistoryContainerService chatHistoryContainer;

    @Inject
    public ChatCoordinator(ChatMessageProcessor chatMessageProcessor, FormattedChatMessageProcessor formattedChatMessageProcessor, ChatBroadcaster chatBroadcaster, ChatHistoryContainerService chatHistoryContainer) {
        this.chatMessageProcessor = chatMessageProcessor;
        this.formattedChatMessageProcessor = formattedChatMessageProcessor;
        this.chatBroadcaster = chatBroadcaster;
        this.chatHistoryContainer = chatHistoryContainer;
    }

    @Override
    public FormattedChatMessage coordinate(ChatMessage chatMessage) {
        if ((chatMessage = this.chatMessageProcessor.process(chatMessage)).isCancelled()) {
            return ((FormattedChatMessage.FormattedChatMessageBuilder)FormattedChatMessage.builder().cancelled(true)).build();
        }
        FormattedChatMessage formattedChatMessage = this.formattedChatMessageProcessor.process(chatMessage);
        EventUtil.callEvent(new ChatBroadcastEvent(formattedChatMessage, formattedChatMessage.isCancelled()), () -> {
            formattedChatMessage.getSender().setLastChat(formattedChatMessage.getChat());
            if (!formattedChatMessage.isVanillaSending() || PlatformType.isProxy()) {
                this.chatBroadcaster.broadcast(formattedChatMessage);
            }
            this.chatHistoryContainer.addMessage(formattedChatMessage.getId(), formattedChatMessage);
        });
        return formattedChatMessage;
    }
}

