/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat.worker;

import java.util.ArrayList;
import java.util.Collections;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.input.WorkerProcessor;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.chat.ChatFormat;
import me.whereareiam.socialismus.api.model.chat.ChatMessages;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.type.chat.Participants;
import me.whereareiam.socialismus.common.requirement.RequirementEvaluator;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class FormatSelector {
    private final RequirementEvaluator requirementEvaluator;
    private final Provider<ChatMessages> chatMessages;
    private final Provider<ChatSettings> chatSettings;

    @Inject
    public FormatSelector(WorkerProcessor<FormattedChatMessage> workerProcessor, RequirementEvaluator requirementEvaluator, Provider<ChatMessages> chatMessages, Provider<ChatSettings> chatSettings) {
        this.requirementEvaluator = requirementEvaluator;
        this.chatMessages = chatMessages;
        this.chatSettings = chatSettings;
        chatMessages.get();
        workerProcessor.addWorker(new Worker<FormattedChatMessage>(this::formatChat, 1, true, false));
    }

    private FormattedChatMessage formatChat(FormattedChatMessage formattedChatMessage) {
        Logger.debug("Formatting chat message for user " + formattedChatMessage.getSender().getUsername(), new Object[0]);
        ChatFormat chatFormat = formattedChatMessage.getChat().getFormats().getLast();
        if (chatFormat == null || !this.checkRequirements(chatFormat, formattedChatMessage)) {
            this.notifyAboutAbsentFormat(formattedChatMessage);
            formattedChatMessage.setCancelled(true);
            return formattedChatMessage;
        }
        Logger.debug("Selected format: " + String.valueOf(chatFormat), new Object[0]);
        formattedChatMessage.setFormat(Serializer.serialize(formattedChatMessage.getSender(), chatFormat.getFormat()));
        return formattedChatMessage;
    }

    private boolean checkRequirements(ChatFormat chatFormat, FormattedChatMessage formattedChatMessage) {
        if (chatFormat.getRequirements().get((Object)Participants.SENDER) == null) {
            return true;
        }
        if (!this.requirementEvaluator.check(chatFormat.getRequirements().get((Object)Participants.SENDER), formattedChatMessage.getSender())) {
            chatFormat = this.getAlternativeChatFormat(chatFormat, formattedChatMessage);
        }
        return chatFormat != null;
    }

    private ChatFormat getAlternativeChatFormat(ChatFormat chatFormat, FormattedChatMessage formattedChatMessage) {
        ArrayList<ChatFormat> formats = new ArrayList<ChatFormat>(formattedChatMessage.getChat().getFormats());
        Collections.reverse(formats);
        formats.remove(chatFormat);
        for (ChatFormat alternativeChat : formats) {
            if (!this.checkRequirements(alternativeChat, formattedChatMessage)) continue;
            return alternativeChat;
        }
        return null;
    }

    private void notifyAboutAbsentFormat(FormattedChatMessage formattedChatMessage) {
        if (!((ChatSettings)this.chatSettings.get()).isNotifyNoFormat()) {
            return;
        }
        formattedChatMessage.getSender().sendMessage(Serializer.serialize(formattedChatMessage.getSender(), ((ChatMessages)this.chatMessages.get()).getNoChatMatch()));
    }
}

