/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat.worker.chatmessage;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.input.WorkerProcessor;
import me.whereareiam.socialismus.api.input.container.ChatContainerService;
import me.whereareiam.socialismus.api.input.event.chat.ChatResolvedEvent;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.chat.ChatMessages;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.InternalChat;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.type.chat.Participants;
import me.whereareiam.socialismus.api.util.ComponentUtil;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.common.requirement.RequirementEvaluator;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.text.TextReplacementConfig;

@Singleton
public class ChatSelector {
    private final ChatContainerService containerService;
    private final RequirementEvaluator requirementEvaluator;
    private final Provider<ChatMessages> chatMessages;
    private final Provider<ChatSettings> chatSettings;

    @Inject
    public ChatSelector(ChatContainerService containerService, RequirementEvaluator requirementEvaluator, Provider<ChatMessages> chatMessages, Provider<ChatSettings> chatSettings, WorkerProcessor<ChatMessage> workerProcessor) {
        this.containerService = containerService;
        this.requirementEvaluator = requirementEvaluator;
        this.chatMessages = chatMessages;
        this.chatSettings = chatSettings;
        workerProcessor.addWorker(new Worker<ChatMessage>(this::selectChat, 50, true, false));
    }

    public ChatMessage selectChat(ChatMessage chatMessage) {
        Logger.debug("Selecting chat for user " + chatMessage.getSender().getUsername(), new Object[0]);
        String symbol = this.selectSymbol(chatMessage);
        List<InternalChat> chats = this.containerService.getChatBySymbol(symbol);
        if (chats.isEmpty()) {
            this.notifyAboutAbsentChat(chatMessage);
            chatMessage.setCancelled(true);
            return chatMessage;
        }
        InternalChat chat = chats.getFirst();
        if (chat == null || !this.checkRequirements(chat, chatMessage)) {
            this.notifyAboutAbsentChat(chatMessage);
            chatMessage.setCancelled(true);
            return chatMessage;
        }
        ChatResolvedEvent event = new ChatResolvedEvent(chatMessage, chat, chatMessage.isCancelled());
        EventUtil.callEvent(event, () -> chatMessage.setChat(event.getChat()));
        Logger.debug("Selected chat: " + String.valueOf(chat), new Object[0]);
        return chatMessage;
    }

    private String selectSymbol(ChatMessage chatMessage) {
        String symbol = String.valueOf(ComponentUtil.toPlain(chatMessage.getContent()).charAt(0));
        if (!this.containerService.hasChatBySymbol(symbol)) {
            return "";
        }
        chatMessage.setContent(chatMessage.getContent().replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(symbol).replacement("").once().build()));
        Logger.debug("Selected chat symbol: " + symbol, new Object[0]);
        return symbol;
    }

    private boolean checkRequirements(InternalChat chat, ChatMessage chatMessage) {
        if (chat.getRequirements().get((Object)Participants.SENDER) == null) {
            return true;
        }
        if (!this.requirementEvaluator.check(chat.getRequirements().get((Object)Participants.SENDER), chatMessage.getSender())) {
            chat = this.getAlternativeChat(chat, chatMessage);
        }
        return chat != null;
    }

    private InternalChat getAlternativeChat(InternalChat chat, ChatMessage chatMessage) {
        ArrayList<InternalChat> chats = new ArrayList<InternalChat>(this.containerService.getChatBySymbol(this.selectSymbol(chatMessage)));
        chats.remove(chat);
        chats.removeIf(c -> c.getId().equals(((ChatSettings)this.chatSettings.get()).getFallback().getChatId()));
        for (InternalChat alternativeChat : chats) {
            if (!this.checkRequirements(alternativeChat, chatMessage)) continue;
            return alternativeChat;
        }
        return this.getFallbackChat(chatMessage);
    }

    private InternalChat getFallbackChat(ChatMessage chatMessage) {
        ChatSettings.FallbackChatSettings fallback = ((ChatSettings)this.chatSettings.get()).getFallback();
        if (!fallback.isEnabled()) {
            return null;
        }
        Optional<InternalChat> fallbackChat = this.containerService.getChat(fallback.getChatId());
        if (fallbackChat.isEmpty()) {
            Logger.warn("Fallback chat is not available", new Object[0]);
            this.notifyPlayerFallbackNotSet(chatMessage);
            chatMessage.setCancelled(true);
            return null;
        }
        return fallbackChat.get();
    }

    private void notifyPlayerFallbackNotSet(ChatMessage chatMessage) {
        if (!((ChatSettings)this.chatSettings.get()).isNotifyNoChat()) {
            return;
        }
        chatMessage.getSender().sendMessage(Serializer.serialize(chatMessage.getSender(), ((ChatMessages)this.chatMessages.get()).getNoFallbackChat()));
    }

    private void notifyAboutAbsentChat(ChatMessage chatMessage) {
        if (!((ChatSettings)this.chatSettings.get()).isNotifyNoChat()) {
            return;
        }
        chatMessage.getSender().sendMessage(Serializer.serialize(chatMessage.getSender(), ((ChatMessages)this.chatMessages.get()).getNoChatMatch()));
    }
}

