/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.velocity;

import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.output.integration.Integration;
import me.whereareiam.socialismus.api.output.integration.SynchronizationIntegration;
import me.whereareiam.socialismus.api.type.Version;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.text.Component;

@Singleton
public class VelocityPlatformInteractor
implements PlatformInteractor {
    private final ProxyServer proxyServer;
    private final Provider<Set<Integration>> integrations;

    @Inject
    public VelocityPlatformInteractor(ProxyServer proxyServer, Provider<Set<Integration>> integrations) {
        this.proxyServer = proxyServer;
        this.integrations = integrations;
    }

    @Override
    public void broadcast(Component component) {
        this.proxyServer.sendMessage(component);
    }

    @Override
    public boolean areWithinRange(UUID player1, UUID player2, double range) {
        Optional<SynchronizationIntegration> syncIntegration;
        if (((Set)this.integrations.get()).stream().anyMatch(i -> i instanceof SynchronizationIntegration) && (syncIntegration = ((Set)this.integrations.get()).stream().filter(i -> i instanceof SynchronizationIntegration).map(i -> (SynchronizationIntegration)i).findFirst()).isPresent()) {
            Optional<String> location1 = syncIntegration.get().getLocation(player1);
            Optional<String> location2 = syncIntegration.get().getLocation(player2);
            if (location1.isPresent() && location2.isPresent()) {
                return location1.get().equals(location2.get());
            }
        }
        return this.proxyServer.getPlayer(player1).flatMap(p1 -> this.proxyServer.getPlayer(player2).flatMap(p2 -> p1.getCurrentServer().flatMap(s1 -> p2.getCurrentServer().map(arg_0 -> ((ServerConnection)s1).equals(arg_0))))).orElse(false);
    }

    @Override
    public boolean hasPermission(String username, String permission) {
        return this.proxyServer.getPlayer(username).map(value -> value.hasPermission(permission)).orElse(false);
    }

    @Override
    public boolean hasPermission(DummyPlayer dummyPlayer, String permission) {
        return this.proxyServer.getPlayer(dummyPlayer.getUniqueId()).map(value -> value.hasPermission(permission)).orElse(false);
    }

    @Override
    public int getOnlinePlayersCount() {
        return this.proxyServer.getPlayerCount();
    }

    @Override
    public Version getServerVersion() {
        return Version.getLatest();
    }
}

