/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.velocity;

import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.api.scheduler.Scheduler;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import me.whereareiam.socialismus.api.model.scheduler.DelayedRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.PeriodicalRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.RunnableTask;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.platform.velocity.VelocitySocialismus;

@Singleton
public class VelocityScheduler
implements me.whereareiam.socialismus.api.output.Scheduler {
    private final VelocitySocialismus socialismus;
    private final Scheduler scheduler;
    private final Map<String, Map<Integer, ScheduledTask>> tasks = new HashMap<String, Map<Integer, ScheduledTask>>();

    @Inject
    public VelocityScheduler(VelocitySocialismus socialismus, ProxyServer proxyServer) {
        this.socialismus = socialismus;
        this.scheduler = proxyServer.getScheduler();
    }

    @Override
    public void schedule(RunnableTask runnableTask) {
        ScheduledTask task = this.scheduler.buildTask((Object)this.socialismus, runnableTask.getRunnable()).schedule();
        this.tasks.put(runnableTask.getModule(), Map.of(runnableTask.getId(), task));
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask) {
        ScheduledTask task = this.scheduler.buildTask((Object)this.socialismus, runnableTask.getRunnable()).delay(Duration.ofMillis(runnableTask.getDelay())).schedule();
        this.tasks.put(runnableTask.getModule(), Map.of(runnableTask.getId(), task));
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask) {
        ScheduledTask task = this.scheduler.buildTask((Object)this.socialismus, runnableTask.getRunnable()).repeat(Duration.ofMillis(runnableTask.getDelay())).schedule();
        this.tasks.put(runnableTask.getModule(), Map.of(runnableTask.getId(), task));
    }

    @Override
    public void schedule(RunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void cancel(RunnableTask runnableTask) {
        if (this.tasks.containsKey(runnableTask.getModule()) && this.tasks.get(runnableTask.getModule()).containsKey(runnableTask.getId())) {
            this.tasks.get(runnableTask.getModule()).get(runnableTask.getId()).cancel();
            this.tasks.get(runnableTask.getModule()).remove(runnableTask.getId());
        }
    }

    @Override
    public void cancel(DelayedRunnableTask runnableTask) {
        this.cancel((RunnableTask)runnableTask);
    }

    @Override
    public void cancelByModule(String module) {
        if (this.tasks.containsKey(module)) {
            this.tasks.get(module).values().forEach(ScheduledTask::cancel);
            this.tasks.remove(module);
        }
    }
}

