/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.velocity.listener;

import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.output.listener.DynamicListener;
import me.whereareiam.socialismus.common.CommonListenerRegistrar;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Injector;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.platform.velocity.VelocitySocialismus;
import me.whereareiam.socialismus.platform.velocity.listener.activity.ServerChangeListener;
import me.whereareiam.socialismus.platform.velocity.listener.chat.PlayerChatListener;
import me.whereareiam.socialismus.platform.velocity.listener.connection.PlayerJoinListener;
import me.whereareiam.socialismus.platform.velocity.listener.connection.PlayerQuitListener;
import me.whereareiam.socialismus.platform.velocity.util.VelocityUtil;

@Singleton
public class VelocityListenerRegistrar
extends CommonListenerRegistrar {
    private final Injector injector;
    private final VelocitySocialismus plugin;
    private final EventManager eventManager;

    @Inject
    public VelocityListenerRegistrar(Injector injector, Provider<Settings> settingsProvider, VelocitySocialismus plugin, EventManager eventManager) {
        super(settingsProvider);
        this.injector = injector;
        this.plugin = plugin;
        this.eventManager = eventManager;
    }

    @Override
    public void registerListeners() {
        this.registerListener(PlayerChatEvent.class, (DynamicListener)this.injector.getInstance(PlayerChatListener.class));
        this.registerListener(ServerPostConnectEvent.class, (DynamicListener)this.injector.getInstance(ServerChangeListener.class));
        this.registerListener(DisconnectEvent.class, (DynamicListener)this.injector.getInstance(PlayerQuitListener.class));
        this.registerListener(PlayerChooseInitialServerEvent.class, (DynamicListener)this.injector.getInstance(PlayerJoinListener.class));
    }

    @Override
    public <T> void registerListener(Class<T> eventClass, DynamicListener<T> listener) {
        if (((Settings)this.settings.get()).getListeners().getEvents().get(eventClass.getName()) != null && !((Settings)this.settings.get()).getListeners().getEvents().get(eventClass.getName()).isRegister()) {
            return;
        }
        Logger.debug("Registering listener for event " + eventClass.getName(), new Object[0]);
        this.eventManager.register((Object)this.plugin, eventClass, VelocityUtil.of(this.determinePriority(eventClass)), listener::onEvent);
    }
}

