/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.velocity.listener.chat;

import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.output.integration.Integration;
import me.whereareiam.socialismus.api.output.integration.SynchronizationIntegration;
import me.whereareiam.socialismus.api.output.listener.DynamicListener;
import me.whereareiam.socialismus.common.chat.ChatCoordinator;
import me.whereareiam.socialismus.common.chat.ChatMessageFactory;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

@Singleton
public class PlayerChatListener
implements DynamicListener<PlayerChatEvent> {
    private final ProxyServer proxyServer;
    private final ChatCoordinator chatCoordinator;
    private final ChatMessageFactory chatMessageFactory;
    private final Provider<Set<Integration>> integrations;

    @Inject
    public PlayerChatListener(ProxyServer proxyServer, ChatCoordinator chatCoordinator, ChatMessageFactory chatMessageFactory, Provider<Set<Integration>> integrations) {
        this.proxyServer = proxyServer;
        this.chatCoordinator = chatCoordinator;
        this.chatMessageFactory = chatMessageFactory;
        this.integrations = integrations;
    }

    @Override
    public void onEvent(PlayerChatEvent event) {
        Player player = event.getPlayer();
        Collection recipients = this.proxyServer.getAllPlayers();
        TextComponent content = Component.text((String)event.getMessage());
        ChatMessage chatMessage = this.chatMessageFactory.createChatMessage(player.getUniqueId(), recipients.stream().map(Player::getUniqueId).collect(Collectors.toSet()), (Component)content);
        if (((Set)this.integrations.get()).stream().anyMatch(i -> i instanceof SynchronizationIntegration)) {
            this.synchronizeChatMessage(chatMessage);
        } else {
            this.chatCoordinator.coordinate(chatMessage);
        }
        event.setResult(PlayerChatEvent.ChatResult.denied());
    }

    private void synchronizeChatMessage(ChatMessage chatMessage) {
        try {
            String data = ChatMessage.serialize(chatMessage);
            ((Set)this.integrations.get()).stream().filter(i -> i instanceof SynchronizationIntegration).findFirst().map(i -> (SynchronizationIntegration)i).ifPresent(i -> i.sync("socialismus", data));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

