/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.deserializer;

import java.io.IOException;
import java.util.List;
import me.whereareiam.socialismus.api.model.requirement.Requirement;
import me.whereareiam.socialismus.api.model.requirement.type.ChatRequirement;
import me.whereareiam.socialismus.api.model.requirement.type.PermissionRequirement;
import me.whereareiam.socialismus.api.model.requirement.type.PlaceholderRequirement;
import me.whereareiam.socialismus.api.model.requirement.type.ServerRequirement;
import me.whereareiam.socialismus.api.model.requirement.type.WorldRequirement;
import me.whereareiam.socialismus.api.type.requirement.RequirementConditionType;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.jackson.core.JsonParser;
import me.whereareiam.socialismus.library.jackson.core.ObjectCodec;
import me.whereareiam.socialismus.library.jackson.core.TreeNode;
import me.whereareiam.socialismus.library.jackson.databind.DeserializationContext;
import me.whereareiam.socialismus.library.jackson.databind.JsonDeserializer;
import me.whereareiam.socialismus.library.jackson.databind.JsonNode;

@Singleton
public class RequirementDeserializer
extends JsonDeserializer<Requirement> {
    private static final List<RequirementConditionType> SIMPLE_CONDITIONS = List.of(RequirementConditionType.EQUALS, RequirementConditionType.CONTAINS);
    private static final List<RequirementConditionType> PLACEHOLDER_CONDITIONS = List.of(RequirementConditionType.EQUALS, RequirementConditionType.GREATER_THAN, RequirementConditionType.LESS_THAN, RequirementConditionType.GREATER_THAN_OR_EQUALS, RequirementConditionType.LESS_THAN_OR_EQUALS);
    private static final List<RequirementConditionType> PERMISSION_CONDITIONS = List.of(RequirementConditionType.HAS, RequirementConditionType.CONTAINS);

    public Requirement deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = parser.getCodec();
        JsonNode root = (JsonNode)codec.readTree(parser);
        if (root.has("servers")) {
            return this.handleRequirement(codec, root, ServerRequirement.class, SIMPLE_CONDITIONS, RequirementConditionType.CONTAINS);
        }
        if (root.has("worlds")) {
            return this.handleRequirement(codec, root, WorldRequirement.class, SIMPLE_CONDITIONS, RequirementConditionType.CONTAINS);
        }
        if (root.has("chatIdentifiers")) {
            return this.handleRequirement(codec, root, ChatRequirement.class, SIMPLE_CONDITIONS, RequirementConditionType.CONTAINS);
        }
        if (root.has("placeholders")) {
            return this.handleRequirement(codec, root, PlaceholderRequirement.class, PLACEHOLDER_CONDITIONS, RequirementConditionType.EQUALS);
        }
        if (root.has("permissions")) {
            return this.handleRequirement(codec, root, PermissionRequirement.class, PERMISSION_CONDITIONS, RequirementConditionType.HAS);
        }
        return null;
    }

    private <T extends Requirement> T handleRequirement(ObjectCodec codec, JsonNode root, Class<T> requirementClass, List<RequirementConditionType> validConditions, RequirementConditionType defaultCondition) throws IOException {
        Requirement requirement = (Requirement)codec.treeToValue((TreeNode)root, requirementClass);
        if (!validConditions.contains((Object)requirement.getCondition())) {
            requirement.setCondition(defaultCondition);
        }
        return (T)requirement;
    }
}

