/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.management;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.whereareiam.socialismus.api.output.DefaultConfig;
import me.whereareiam.socialismus.api.output.config.ConfigurationManager;
import me.whereareiam.socialismus.api.output.config.ConfigurationTypeResolver;
import me.whereareiam.socialismus.api.type.ConfigurationType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class DefaultConfigurationManager
implements ConfigurationManager {
    private final ConfigurationTypeResolver typeResolver;
    private final Map<Class<?>, DefaultConfig<?>> templates = new ConcurrentHashMap();

    @Inject
    public DefaultConfigurationManager(ConfigurationTypeResolver typeResolver, @Named(value="configTemplates") Map<Class<?>, DefaultConfig<?>> bootstrap) {
        this.typeResolver = typeResolver;
        this.templates.putAll(bootstrap);
    }

    @Override
    public ConfigurationType getConfigurationType() {
        return this.typeResolver.getConfigurationType();
    }

    @Override
    public void addTemplate(Class<?> type, DefaultConfig<?> template) {
        this.templates.put(type, template);
    }

    @Override
    public <T> DefaultConfig<T> getTemplate(Class<T> type) {
        return this.templates.get(type);
    }
}

