/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.management;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import me.whereareiam.socialismus.api.input.registry.ObjectMapperRegistry;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.jackson.databind.JsonDeserializer;
import me.whereareiam.socialismus.library.jackson.databind.JsonSerializer;
import me.whereareiam.socialismus.library.jackson.databind.Module;
import me.whereareiam.socialismus.library.jackson.databind.ObjectMapper;
import me.whereareiam.socialismus.library.jackson.databind.module.SimpleModule;

@Singleton
public class DefaultObjectMapperRegistry
implements ObjectMapperRegistry {
    private final List<Module> dynamicModules = new CopyOnWriteArrayList<Module>();
    private volatile ObjectMapper builtMapper;

    @Override
    public <T> void addSerializer(Class<T> type, Object serializer) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(type, (JsonSerializer)serializer);
        this.dynamicModules.add((Module)module);
        if (this.builtMapper != null) {
            this.builtMapper.registerModule((Module)module);
        }
    }

    @Override
    public <T> void addDeserializer(Class<T> type, Object deserializer) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(type, (JsonDeserializer)deserializer);
        this.dynamicModules.add((Module)module);
        if (this.builtMapper != null) {
            this.builtMapper.registerModule((Module)module);
        }
    }

    public void applyAllTo(ObjectMapper mapper) {
        this.builtMapper = mapper;
        for (Module mod : this.dynamicModules) {
            mapper.registerModule(mod);
        }
    }
}

