/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.provider;

import java.nio.file.Path;
import me.whereareiam.socialismus.adapter.config.management.DefaultConfigurationLoader;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class MessagesProvider
implements Provider<Messages>,
Reloadable {
    private final Path dataPath;
    private final DefaultConfigurationLoader defaultConfigurationLoader;
    private Messages messages;

    @Inject
    public MessagesProvider(@Named(value="dataPath") Path dataPath, DefaultConfigurationLoader defaultConfigurationLoader, Registry<Reloadable> registry) {
        this.dataPath = dataPath;
        this.defaultConfigurationLoader = defaultConfigurationLoader;
        registry.register(this);
    }

    public Messages get() {
        if (this.messages != null) {
            return this.messages;
        }
        this.load();
        return this.messages;
    }

    @Override
    public void reload() {
        this.load();
    }

    private void load() {
        this.messages = this.defaultConfigurationLoader.load(this.dataPath.resolve("messages"), Messages.class);
    }
}

