/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.resolver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Stream;
import me.whereareiam.socialismus.api.output.config.ConfigurationTypeResolver;
import me.whereareiam.socialismus.api.type.ConfigurationType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.name.Named;

public class FileSystemConfigurationTypeResolver
implements ConfigurationTypeResolver {
    private final Path dataPath;

    @Inject
    public FileSystemConfigurationTypeResolver(@Named(value="dataPath") Path dataPath) {
        this.dataPath = dataPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigurationType getConfigurationType() {
        try (Stream<Path> paths = Files.list(this.dataPath);){
            Optional<Path> configFile = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().startsWith("type=")).findFirst();
            if (configFile.isPresent()) {
                String[] parts = configFile.get().getFileName().toString().split("=", 2);
                ConfigurationType configurationType2 = ConfigurationType.valueOf(parts[1].toUpperCase());
                return configurationType2;
            }
            Files.createFile(this.dataPath.resolve("type=YAML"), new FileAttribute[0]);
            ConfigurationType configurationType = ConfigurationType.YAML;
            return configurationType;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get configuration type", e);
        }
    }
}

