/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.template;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.whereareiam.socialismus.api.Constants;
import me.whereareiam.socialismus.api.model.Event;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.output.DefaultConfig;
import me.whereareiam.socialismus.api.type.EventPriority;
import me.whereareiam.socialismus.api.type.PlatformType;
import me.whereareiam.socialismus.api.type.SerializationType;
import me.whereareiam.socialismus.api.type.Version;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class SettingsTemplate
implements DefaultConfig<Settings> {
    @Override
    public Settings getDefault() {
        Settings settings = new Settings();
        settings.setLevel(2);
        settings.setSerializer(SerializationType.MINIMESSAGE);
        Settings.Synchronization synchronization = new Settings.Synchronization();
        synchronization.setEnabled(false);
        synchronization.setServer(UUID.randomUUID().toString());
        synchronization.setUseRealServerName(false);
        synchronization.setCrossPlayerSync(true);
        settings.setSynchronization(synchronization);
        Settings.Miscellaneous misc = new Settings.Miscellaneous();
        misc.setDisableJoinNotification(true);
        misc.setDisableQuitNotification(true);
        misc.setAllowLegacyParsing(false);
        misc.setAllowBrigadierCommands(false);
        misc.setVanillaSending(true);
        misc.setCommandsPerPage(7);
        settings.setMisc(misc);
        Settings.Updater updater = new Settings.Updater();
        updater.setCheckForUpdates(true);
        updater.setWarnAboutUpdates(true);
        updater.setWarnAboutLocalBuilds(true);
        updater.setWarnAboutDevBuilds(true);
        updater.setInterval(1);
        settings.setUpdater(updater);
        Settings.Listeners listeners = new Settings.Listeners();
        if (PlatformType.isProxy()) {
            listeners.setEvents(this.getPrioritiesForProxy());
        }
        if (PlatformType.isAtLeast(PlatformType.PAPER)) {
            listeners.setEvents(this.getPrioritiesForPaper());
        } else if (PlatformType.isAtLeast(PlatformType.BUKKIT)) {
            listeners.setEvents(this.getPrioritiesForBukkit());
        }
        settings.setListeners(listeners);
        return settings;
    }

    private Map<String, Event> getPrioritiesForBukkit() {
        HashMap<String, Event> priorities = new HashMap<String, Event>();
        Object event = ((Event.EventBuilder)((Event.EventBuilder)Event.builder().register(true)).priority(EventPriority.LOWEST)).build();
        priorities.put("org.bukkit.event.player.PlayerLoginEvent", (Event)event);
        priorities.put("org.bukkit.event.player.PlayerJoinEvent", (Event)event);
        priorities.put("org.bukkit.event.player.PlayerQuitEvent", (Event)event);
        priorities.put("org.bukkit.event.player.PlayerChangedWorldEvent", (Event)event);
        priorities.put("org.bukkit.event.player.AsyncPlayerChatEvent", (Event)event);
        return priorities;
    }

    private Map<String, Event> getPrioritiesForPaper() {
        HashMap<String, Event> priorities = new HashMap<String, Event>();
        Object event = ((Event.EventBuilder)((Event.EventBuilder)Event.builder().register(true)).priority(EventPriority.LOWEST)).build();
        priorities.put("org.bukkit.event.player.PlayerJoinEvent", (Event)event);
        priorities.put("org.bukkit.event.player.PlayerQuitEvent", (Event)event);
        priorities.put("org.bukkit.event.player.PlayerChangedWorldEvent", (Event)event);
        priorities.put("io.papermc.paper.event.player.AsyncChatEvent", (Event)event);
        if (Constants.SERVER_VERSION.isAtLeast(Version.V_1_21_6)) {
            priorities.put("io.papermc.paper.event.connection.configuration.PlayerConnectionInitialConfigureEvent", (Event)event);
            return priorities;
        }
        priorities.put("org.bukkit.event.player.PlayerLoginEvent", (Event)event);
        return priorities;
    }

    private Map<String, Event> getPrioritiesForProxy() {
        HashMap<String, Event> priorities = new HashMap<String, Event>();
        Object event = ((Event.EventBuilder)((Event.EventBuilder)Event.builder().register(true)).priority(EventPriority.LOWEST)).build();
        priorities.put("com.velocitypowered.api.event.player.ServerPostConnectEvent", (Event)event);
        priorities.put("com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent", (Event)event);
        priorities.put("com.velocitypowered.api.event.player.PlayerChatEvent", (Event)event);
        priorities.put("com.velocitypowered.api.event.connection.DisconnectEvent", (Event)event);
        return priorities;
    }
}

