/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.module;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import me.whereareiam.socialismus.adapter.module.resolver.ModuleDependencyResolver;
import me.whereareiam.socialismus.adapter.module.resolver.ModulePlatformResolver;
import me.whereareiam.socialismus.adapter.module.resolver.ModuleResolver;
import me.whereareiam.socialismus.adapter.module.resolver.ModuleResourceResolver;
import me.whereareiam.socialismus.adapter.module.resolver.ModuleVersionResolver;
import me.whereareiam.socialismus.api.AnsiColor;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.exception.ModuleLifecycleException;
import me.whereareiam.socialismus.api.model.module.InternalModule;
import me.whereareiam.socialismus.api.output.PlatformClassLoader;
import me.whereareiam.socialismus.api.output.module.SocialisticModule;
import me.whereareiam.socialismus.api.output.resource.ResourceProvider;
import me.whereareiam.socialismus.api.output.resource.ResourceRegistry;
import me.whereareiam.socialismus.api.type.ResourceType;
import me.whereareiam.socialismus.api.type.module.ModuleState;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Injector;
import me.whereareiam.socialismus.library.guice.ProvisionException;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ModuleLifecycleController {
    private final Injector injector;
    private final PlatformClassLoader platformClassLoader;
    private final ResourceRegistry registry;
    private final List<ModuleResolver> resolvers;

    @Inject
    public ModuleLifecycleController(Injector injector, PlatformClassLoader platformClassLoader, ResourceRegistry registry) {
        this.injector = injector;
        this.platformClassLoader = platformClassLoader;
        this.registry = registry;
        this.resolvers = List.of((ModuleResolver)injector.getInstance(ModuleDependencyResolver.class), (ModuleResolver)injector.getInstance(ModuleVersionResolver.class), (ModuleResolver)injector.getInstance(ModulePlatformResolver.class), (ModuleResolver)injector.getInstance(ModuleResourceResolver.class));
    }

    public void loadModule(InternalModule module) {
        if (!module.getState().equals((Object)ModuleState.UNKNOWN)) {
            return;
        }
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{module.getPath().toUri().toURL()}, this.platformClassLoader.getClassLoader());
            Class<?> moduleClass = Class.forName(module.getMain(), true, loader);
            module.setModule((SocialisticModule)this.injector.getInstance(moduleClass));
            module.setState(ModuleState.LOADED);
            module.getModule().setModule(module);
            module.getModule().setWorkingPath(module.getPath().getParent().resolve(module.getName()));
            this.injector.injectMembers((Object)module.getModule());
            if (this.checkRequirements(module)) {
                return;
            }
            try {
                module.getModule().onLoad();
                SocialisticModule socialisticModule = module.getModule();
                if (socialisticModule instanceof ResourceProvider) {
                    ResourceProvider provider = (ResourceProvider)((Object)socialisticModule);
                    provider.provideResources().forEach((k, v) -> {
                        this.registry.register((ResourceType)((Object)k), v);
                        Logger.info("Registered resource " + String.valueOf(k) + " from module " + module.getName(), new Object[0]);
                    });
                }
            }
            catch (ModuleLifecycleException | ProvisionException ex) {
                Logger.severe("Module " + module.getName() + " aborted load: " + ex.getMessage(), new Object[0]);
                module.setState(ModuleState.ERROR);
                return;
            }
            Logger.info("Loaded module " + String.valueOf((Object)AnsiColor.YELLOW) + module.getName() + String.valueOf((Object)AnsiColor.RESET) + " v" + module.getVersion() + " [" + String.join((CharSequence)", ", module.getAuthors()) + "]", new Object[0]);
        }
        catch (ClassNotFoundException | MalformedURLException e) {
            Logger.severe("Failed to load module " + module.getName() + ": " + String.valueOf(e), new Object[0]);
            module.setState(ModuleState.ERROR);
        }
    }

    public void enableModule(InternalModule module) {
        if (!module.getState().equals((Object)ModuleState.LOADED)) {
            return;
        }
        module.setState(ModuleState.ENABLED);
        try {
            module.getModule().onEnable();
        }
        catch (ModuleLifecycleException ex) {
            Logger.severe("Module " + module.getName() + " aborted enable: " + ex.getMessage(), new Object[0]);
            module.setState(ModuleState.ERROR);
        }
    }

    public void disableModule(InternalModule module) {
        if (!module.getState().equals((Object)ModuleState.ENABLED)) {
            return;
        }
        module.setState(ModuleState.DISABLED);
        module.getModule().onDisable();
    }

    public void unloadModule(InternalModule module) {
        if (!module.getState().equals((Object)ModuleState.DISABLED)) {
            return;
        }
        module.setState(ModuleState.UNLOADED);
        module.getModule().onUnload();
        SocialisticModule socialisticModule = module.getModule();
        if (socialisticModule instanceof ResourceProvider) {
            ResourceProvider provider = (ResourceProvider)((Object)socialisticModule);
            provider.provideResources().keySet().forEach(this.registry::unregister);
        }
    }

    private boolean checkRequirements(InternalModule module) {
        for (ModuleResolver resolver : this.resolvers) {
            if (resolver.resolve(module)) continue;
            module.setState(ModuleState.ERROR);
            return true;
        }
        return false;
    }
}

