/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.module;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import me.whereareiam.socialismus.adapter.module.ModuleLifecycleController;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.model.module.InternalModule;
import me.whereareiam.socialismus.api.model.module.Module;
import me.whereareiam.socialismus.api.model.module.ModuleDependency;
import me.whereareiam.socialismus.api.output.config.ConfigurationLoader;
import me.whereareiam.socialismus.api.output.module.ModuleService;
import me.whereareiam.socialismus.api.type.module.DependencyType;
import me.whereareiam.socialismus.api.type.module.ModuleState;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class ModuleManager
implements ModuleService {
    private static final String MODULE_FILE = "module.json";
    private final Path modulesPath;
    private final ConfigurationLoader configurationLoader;
    private final ModuleLifecycleController lifecycleController;
    private List<InternalModule> modules = new ArrayList<InternalModule>();

    @Inject
    public ModuleManager(@Named(value="modulesPath") Path modulesPath, ConfigurationLoader configurationLoader, ModuleLifecycleController moduleLifecycleController) {
        this.modulesPath = modulesPath;
        this.configurationLoader = configurationLoader;
        this.lifecycleController = moduleLifecycleController;
    }

    @Override
    public Optional<InternalModule> getModule(String name) {
        return this.modules.stream().filter(module -> module.getName().equals(name)).findFirst();
    }

    @Override
    public void loadModules() {
        this.discoverModules();
        this.modules.forEach(this.lifecycleController::loadModule);
        this.modules.forEach(this.lifecycleController::enableModule);
    }

    @Override
    public void unloadModules() {
        Logger.info("Unloading modules...", new Object[0]);
        this.modules.forEach(this.lifecycleController::disableModule);
        this.modules.forEach(this.lifecycleController::unloadModule);
        this.modules.removeIf(module -> !module.getState().equals((Object)ModuleState.UNLOADED));
        this.modules.forEach(module -> Logger.warn("Module was not unloaded: " + module.getName(), new Object[0]));
    }

    @Override
    public void reloadModules() {
        this.unloadModules();
        this.loadModules();
    }

    private void discoverModules() {
        try (Stream<Path> paths = Files.list(this.modulesPath);){
            List<File> moduleFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".jar")).map(Path::toFile).toList();
            moduleFiles.forEach(file -> {
                try (JarFile jarFile = new JarFile((File)file);){
                    JarEntry entry = jarFile.getJarEntry(MODULE_FILE);
                    if (entry == null) {
                        Logger.warn("Module file does not contain module.json file: " + file.getName(), new Object[0]);
                        return;
                    }
                    try (InputStream stream = jarFile.getInputStream(entry);){
                        Module module = this.configurationLoader.load(stream, Module.class);
                        if (!this.validateModule(module, (File)file)) {
                            return;
                        }
                        this.modules.add((InternalModule)((InternalModule.InternalModuleBuilder)((InternalModule.InternalModuleBuilder)((InternalModule.InternalModuleBuilder)((InternalModule.InternalModuleBuilder)((InternalModule.InternalModuleBuilder)((InternalModule.InternalModuleBuilder)((InternalModule.InternalModuleBuilder)((InternalModule.InternalModuleBuilder)((Module.ModuleBuilder)((InternalModule.InternalModuleBuilder)InternalModule.builder().path(file.toPath())).state(ModuleState.UNKNOWN)).name(module.getName())).version(module.getVersion())).authors(module.getAuthors())).supportedPlatforms(module.getSupportedPlatforms())).supportedVersions(module.getSupportedVersions())).dependencies(module.getDependencies())).updater(module.getUpdater())).main(module.getMain())).build());
                    }
                }
                catch (IOException e) {
                    Logger.warn("Failed to load module from file: " + file.getName(), new Object[0]);
                }
                List<InternalModule> sortedModules = this.sortModulesByDependencies(this.modules);
                this.modules.clear();
                this.modules.addAll(sortedModules);
            });
        }
        catch (IOException e) {
            Logger.warn("Failed to load modules from directory: " + String.valueOf(this.modulesPath), new Object[0]);
        }
    }

    private List<InternalModule> sortModulesByDependencies(List<InternalModule> modules) {
        Map<String, InternalModule> moduleMap = modules.stream().collect(Collectors.toMap(Module::getName, module -> module));
        HashMap<String, List<String>> dependencyGraph = new HashMap<String, List<String>>();
        for (InternalModule module2 : modules) {
            List dependencies = module2.getDependencies().stream().filter(dep -> dep.getType() == DependencyType.MODULE).map(ModuleDependency::getName).collect(Collectors.toList());
            dependencyGraph.put(module2.getName(), dependencies);
        }
        ArrayList<InternalModule> sortedModules = new ArrayList<InternalModule>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> visiting = new HashSet<String>();
        for (InternalModule module3 : modules) {
            if (visited.contains(module3.getName()) || !this.topologicalSort(module3.getName(), dependencyGraph, visited, visiting, sortedModules, moduleMap)) continue;
            Logger.warn("Cyclic dependency detected in modules", new Object[0]);
            return modules;
        }
        return sortedModules;
    }

    private boolean topologicalSort(String moduleName, Map<String, List<String>> dependencyGraph, Set<String> visited, Set<String> visiting, List<InternalModule> sortedModules, Map<String, InternalModule> moduleMap) {
        if (visiting.contains(moduleName)) {
            return true;
        }
        if (visited.contains(moduleName)) {
            return false;
        }
        visiting.add(moduleName);
        for (String dependency : dependencyGraph.getOrDefault(moduleName, Collections.emptyList())) {
            if (!this.topologicalSort(dependency, dependencyGraph, visited, visiting, sortedModules, moduleMap)) continue;
            return true;
        }
        visiting.remove(moduleName);
        visited.add(moduleName);
        sortedModules.add(moduleMap.get(moduleName));
        return false;
    }

    private boolean validateModule(Module module, File moduleJson) {
        if (module == null) {
            Logger.warn("Failed to open module.json file: " + moduleJson.getName(), new Object[0]);
            return false;
        }
        if (module.getName() == null || module.getVersion() == null || module.getMain() == null) {
            Logger.warn("Module file is missing required fields: " + moduleJson.getName(), new Object[0]);
            return false;
        }
        if (this.modules.stream().anyMatch(internalModule -> internalModule.getName().equals(module.getName()))) {
            Logger.warn("Module with name already exists: " + module.getName(), new Object[0]);
            return false;
        }
        return true;
    }

    @Generated
    public Path getModulesPath() {
        return this.modulesPath;
    }

    @Generated
    public ConfigurationLoader getConfigurationLoader() {
        return this.configurationLoader;
    }

    @Generated
    public ModuleLifecycleController getLifecycleController() {
        return this.lifecycleController;
    }

    @Override
    @Generated
    public List<InternalModule> getModules() {
        return this.modules;
    }

    @Generated
    public void setModules(List<InternalModule> modules) {
        this.modules = modules;
    }
}

