/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.management;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.output.command.CommandService;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.incendo.cloud.annotations.string.PatternReplacingStringProcessor;

@Singleton
public class CommandTranslator {
    private static final Pattern COMMAND_PATTERN = Pattern.compile("%command\\.(.*)");
    private static final Pattern PERMISSION_PATTERN = Pattern.compile("%permission\\.(.*)");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("%description\\.(.*)");
    private static final Pattern USAGE_PATTERN = Pattern.compile("%usage\\.(.*)");
    private final Provider<Map<String, CommandEntity>> commands;
    private final CommandService commandService;

    public PatternReplacingStringProcessor getProcessor() {
        HashMap<Pattern, Function<CommandEntity, String>> patternFunctionMap = new HashMap<Pattern, Function<CommandEntity, String>>();
        patternFunctionMap.put(COMMAND_PATTERN, command -> this.getTranslation("command." + command.getAliases().get(0) + ".name"));
        patternFunctionMap.put(PERMISSION_PATTERN, command -> this.getTranslation("command." + command.getAliases().get(0) + ".permission"));
        patternFunctionMap.put(DESCRIPTION_PATTERN, command -> this.getTranslation("command." + command.getAliases().get(0) + ".description"));
        patternFunctionMap.put(USAGE_PATTERN, command -> this.getTranslation("command." + command.getAliases().get(0) + ".usage"));
        Function<MatchResult, String> replacementFunction = matchResult -> {
            String input = matchResult.group(0);
            for (Map.Entry entry : patternFunctionMap.entrySet()) {
                Matcher matcher = ((Pattern)entry.getKey()).matcher(input);
                if (!matcher.find()) continue;
                String commandName = matcher.group(1);
                CommandEntity commandEntity = (CommandEntity)((Map)this.commands.get()).get(commandName);
                if (commandEntity == null) continue;
                String result = (String)((Function)entry.getValue()).apply(commandEntity);
                if (result == null || result.isEmpty()) {
                    return "";
                }
                return result.replace("{command}", String.join((CharSequence)"|", ((CommandEntity)((Map)this.commands.get()).get("main")).getAliases()));
            }
            return input;
        };
        return new PatternReplacingStringProcessor(Pattern.compile(".*"), replacementFunction);
    }

    private String getTranslation(String key) {
        return this.commandService.getTranslation(key);
    }

    @Inject
    @Generated
    public CommandTranslator(Provider<Map<String, CommandEntity>> commands, CommandService commandService) {
        this.commands = commands;
        this.commandService = commandService;
    }
}

