/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.provider;

import lombok.Generated;
import me.whereareiam.socialismus.api.Constants;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.type.PlatformType;
import me.whereareiam.socialismus.api.type.Version;
import me.whereareiam.socialismus.command.management.CommandExceptionHandler;
import me.whereareiam.socialismus.library.guice.Provider;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.exception.ArgumentParseException;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.InvalidCommandSenderException;
import org.incendo.cloud.exception.InvalidSyntaxException;
import org.incendo.cloud.exception.NoPermissionException;
import org.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;

public abstract class CommandManagerProvider
implements Provider<CommandManager<DummyPlayer>> {
    protected final Provider<Settings> settings;
    private final CommandExceptionHandler exceptionHandler;
    private CommandManager<DummyPlayer> commandManager;

    public CommandManager<DummyPlayer> get() {
        if (this.commandManager != null) {
            return this.commandManager;
        }
        this.commandManager = switch (PlatformType.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PlatformType.BUKKIT, PlatformType.SPIGOT -> this.createLegacyPaperCommandManager();
            case PlatformType.FOLIA, PlatformType.PAPER -> {
                if (Constants.SERVER_VERSION.isAtLeast(Version.V_1_20_5) && ((Settings)this.settings.get()).getMisc().isAllowBrigadierCommands() || Constants.SERVER_VERSION.isAtLeast(Version.V_1_20_5)) {
                    yield this.createPaperCommandManager();
                }
                yield this.createLegacyPaperCommandManager();
            }
            case PlatformType.VELOCITY -> this.createVelocityCommandManager();
            case PlatformType.UNKNOWN -> throw new IllegalStateException("Unknown platform type");
        };
        this.createMinecraftExceptionHandler(this.commandManager);
        return this.commandManager;
    }

    protected abstract CommandManager<DummyPlayer> createLegacyPaperCommandManager();

    protected abstract CommandManager<DummyPlayer> createPaperCommandManager();

    protected abstract CommandManager<DummyPlayer> createVelocityCommandManager();

    private void createMinecraftExceptionHandler(CommandManager<DummyPlayer> commandManager) {
        MinecraftExceptionHandler.create(DummyPlayer::getAudience).handler(ArgumentParseException.class, this.exceptionHandler::handleParseException).handler(InvalidCommandSenderException.class, this.exceptionHandler::handleInvalidCommandSenderException).handler(NoPermissionException.class, this.exceptionHandler::handleNoPermissionException).handler(InvalidSyntaxException.class, this.exceptionHandler::handleInvalidSyntaxException).handler(CommandExecutionException.class, this.exceptionHandler::handleCommandExecutionException).registerTo(commandManager);
    }

    @Generated
    public CommandManagerProvider(Provider<Settings> settings, CommandExceptionHandler exceptionHandler) {
        this.settings = settings;
        this.exceptionHandler = exceptionHandler;
    }
}

