/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common;

import me.whereareiam.socialismus.api.Constants;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.input.event.plugin.PluginInitializedEvent;
import me.whereareiam.socialismus.api.input.serializer.ComponentService;
import me.whereareiam.socialismus.api.model.chat.ChatMessages;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.output.LoggingHelper;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.output.command.CommandService;
import me.whereareiam.socialismus.api.output.listener.ListenerRegistrar;
import me.whereareiam.socialismus.api.output.module.ModuleService;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.common.CommonInjector;
import me.whereareiam.socialismus.common.SynchronizationService;
import me.whereareiam.socialismus.common.chat.worker.base.ChatSelector;
import me.whereareiam.socialismus.common.chat.worker.base.RecipientResolver;
import me.whereareiam.socialismus.common.chat.worker.base.RecipientSelector;
import me.whereareiam.socialismus.common.chat.worker.formatted.FormatSelector;
import me.whereareiam.socialismus.common.container.ChatContainer;
import me.whereareiam.socialismus.common.printer.WelcomeBannerPrinter;
import me.whereareiam.socialismus.common.updater.UpdateScheduler;
import me.whereareiam.socialismus.library.guice.Injector;

public class CommonSocialismus {
    private Injector injector;

    public void onLoad() {
        this.injector = CommonInjector.getInjector();
        Constants.SERVER_VERSION = ((PlatformInteractor)this.injector.getInstance(PlatformInteractor.class)).getServerVersion();
        Logger.init((LoggingHelper)this.injector.getInstance(LoggingHelper.class));
        Serializer.init((ComponentService)this.injector.getInstance(ComponentService.class));
    }

    public void onEnable() {
        this.injector.getInstance(ChatContainer.class);
        this.injector.getInstance(RecipientResolver.class);
        this.injector.getInstance(ChatSelector.class);
        this.injector.getInstance(RecipientSelector.class);
        this.injector.getInstance(FormatSelector.class);
        this.injector.getInstance(ChatMessages.class);
        this.injector.getInstance(ChatSettings.class);
        ((CommandService)this.injector.getInstance(CommandService.class)).initialize();
        ((ModuleService)this.injector.getInstance(ModuleService.class)).loadModules();
        ((ListenerRegistrar)this.injector.getInstance(ListenerRegistrar.class)).registerListeners();
        ((SynchronizationService)this.injector.getInstance(SynchronizationService.class)).initialize();
        ((WelcomeBannerPrinter)this.injector.getInstance(WelcomeBannerPrinter.class)).print();
        ((UpdateScheduler)this.injector.getInstance(UpdateScheduler.class)).start();
        EventUtil.callEvent(new PluginInitializedEvent(), () -> {});
    }

    public void onDisable() {
    }
}

