/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat.processor;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import lombok.Generated;
import me.whereareiam.socialismus.api.input.WorkerProcessor;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.text.Component;

@Singleton
public class FormattedChatMessageProcessor
implements WorkerProcessor<FormattedChatMessage> {
    private final LinkedList<Worker<FormattedChatMessage>> workers = new LinkedList();
    private final Provider<Settings> settings;

    public FormattedChatMessage process(ChatMessage chatMessage) {
        Worker worker;
        FormattedChatMessage formattedChatMessage = FormattedChatMessage.from(chatMessage, (Component)Component.empty(), ((Settings)this.settings.get()).getMisc().isVanillaSending());
        Iterator iterator = this.workers.iterator();
        while (iterator.hasNext() && !(formattedChatMessage = (FormattedChatMessage)(worker = (Worker)iterator.next()).getFunction().apply(formattedChatMessage)).isCancelled()) {
        }
        return formattedChatMessage;
    }

    @Override
    public void addWorker(Worker<FormattedChatMessage> worker) {
        if (this.workers.stream().noneMatch(w -> w.getPriority() == worker.getPriority())) {
            this.workers.add(worker);
            this.workers.sort(Comparator.comparingInt(Worker::getPriority));
        }
    }

    @Override
    public boolean removeWorker(Worker<FormattedChatMessage> worker) {
        if (!worker.isRemovable()) {
            return false;
        }
        return this.workers.remove(worker);
    }

    @Override
    @Generated
    public LinkedList<Worker<FormattedChatMessage>> getWorkers() {
        return this.workers;
    }

    @Generated
    public Provider<Settings> getSettings() {
        return this.settings;
    }

    @Inject
    @Generated
    public FormattedChatMessageProcessor(Provider<Settings> settings) {
        this.settings = settings;
    }
}

