/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat.worker.formatted;

import me.whereareiam.socialismus.api.Constants;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.WorkerProcessor;
import me.whereareiam.socialismus.api.input.sync.ChatSyncBus;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class SynchronizationPublisher {
    private final ChatSyncBus syncBus;
    private final Provider<ChatSettings> chatSettings;

    @Inject
    public SynchronizationPublisher(WorkerProcessor<FormattedChatMessage> workerProcessor, ChatSyncBus syncBus, Provider<ChatSettings> chatSettings) {
        this.syncBus = syncBus;
        this.chatSettings = chatSettings;
        workerProcessor.addWorker(new Worker<FormattedChatMessage>(this::publish, 50, true, false));
    }

    private FormattedChatMessage publish(FormattedChatMessage msg) {
        if (!((ChatSettings)this.chatSettings.get()).getSynchronization().isEnabled()) {
            return msg;
        }
        if (msg.getOrigin() != null && !msg.getOrigin().equals(Constants.IDENTIFIER)) {
            return msg;
        }
        this.syncBus.publish(msg);
        Logger.debug("Synced formatted chat #%s from %s", msg.getId(), msg.getSender().getUsername());
        return msg;
    }
}

