/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.requirement.validation;

import java.util.List;
import java.util.Set;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.registry.ExtendedRegistry;
import me.whereareiam.socialismus.api.input.requirement.RequirementValidation;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.requirement.Requirement;
import me.whereareiam.socialismus.api.model.requirement.type.PlaceholderRequirement;
import me.whereareiam.socialismus.api.output.integration.Integration;
import me.whereareiam.socialismus.api.output.integration.PlaceholderResolverIntegration;
import me.whereareiam.socialismus.api.type.requirement.RequirementConditionType;
import me.whereareiam.socialismus.api.type.requirement.RequirementType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class PlaceholderRequirementValidation
implements RequirementValidation {
    private final Set<Integration> integrations;

    @Inject
    public PlaceholderRequirementValidation(ExtendedRegistry<RequirementType, RequirementValidation> registry, Set<Integration> integrations) {
        this.integrations = integrations;
        registry.register(RequirementType.PLACEHOLDER, this);
    }

    @Override
    public boolean check(Requirement requirement, DummyPlayer dummyPlayer) {
        PlaceholderResolverIntegration resolver = this.findPlaceholderResolverIntegration();
        if (resolver == null || !(requirement instanceof PlaceholderRequirement)) {
            return false;
        }
        PlaceholderRequirement pr = (PlaceholderRequirement)requirement;
        Logger.debug("Checking placeholder requirement for player " + dummyPlayer.getUsername(), new Object[0]);
        return this.checkCondition(pr, resolver, dummyPlayer);
    }

    private PlaceholderResolverIntegration findPlaceholderResolverIntegration() {
        return this.integrations.stream().filter(integration -> integration instanceof PlaceholderResolverIntegration).map(integration -> (PlaceholderResolverIntegration)integration).findFirst().orElse(null);
    }

    private boolean checkCondition(PlaceholderRequirement pr, PlaceholderResolverIntegration resolver, DummyPlayer dummyPlayer) {
        List<String> placeholders = pr.getPlaceholders();
        String[] expectedValues = pr.getExpected().split("\\|");
        for (String placeholder : placeholders) {
            String resolvedPlaceholder = resolver.format(dummyPlayer, placeholder);
            for (String expected : expectedValues) {
                boolean result;
                switch (pr.getCondition()) {
                    case EQUALS: {
                        boolean equals = resolvedPlaceholder.equals(expected);
                        Logger.debug("EQUALS comparison: '" + resolvedPlaceholder + "' == '" + expected + "' = " + equals, new Object[0]);
                        boolean bl = equals;
                        break;
                    }
                    case GREATER_THAN: 
                    case LESS_THAN: 
                    case GREATER_THAN_OR_EQUALS: 
                    case LESS_THAN_OR_EQUALS: {
                        boolean comparison = this.compareNumericValues(pr, resolvedPlaceholder, expected);
                        Logger.debug("Numeric comparison " + String.valueOf((Object)pr.getCondition()) + " for values: " + resolvedPlaceholder + " " + String.valueOf((Object)pr.getCondition()) + " " + expected + " = " + comparison, new Object[0]);
                        boolean bl = String.valueOf(comparison).equals(expected);
                        break;
                    }
                    default: {
                        boolean bl = result = false;
                    }
                }
                if (!result) continue;
                Logger.debug("Found matching condition for player " + dummyPlayer.getUsername(), new Object[0]);
                return true;
            }
        }
        Logger.debug("No matching conditions found for player " + dummyPlayer.getUsername(), new Object[0]);
        return false;
    }

    private boolean compareNumericValues(PlaceholderRequirement pr, String formattedValue, String expected) {
        try {
            double value = Double.parseDouble(formattedValue);
            double expectedValue = Double.parseDouble(expected);
            boolean result = switch (pr.getCondition()) {
                case RequirementConditionType.GREATER_THAN -> {
                    if (value > expectedValue) {
                        yield true;
                    }
                    yield false;
                }
                case RequirementConditionType.LESS_THAN -> {
                    if (value < expectedValue) {
                        yield true;
                    }
                    yield false;
                }
                case RequirementConditionType.GREATER_THAN_OR_EQUALS -> {
                    if (value >= expectedValue) {
                        yield true;
                    }
                    yield false;
                }
                case RequirementConditionType.LESS_THAN_OR_EQUALS -> {
                    if (value <= expectedValue) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
            Logger.debug("Numeric comparison result: " + result + " for values: " + value + " " + String.valueOf((Object)pr.getCondition()) + " " + expectedValue, new Object[0]);
            return result;
        }
        catch (NumberFormatException e) {
            Logger.debug("Failed to parse numeric values: " + formattedValue + " " + String.valueOf((Object)pr.getCondition()) + " " + expected, new Object[0]);
            return false;
        }
    }
}

