/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.serializer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.input.serializer.ComponentService;
import me.whereareiam.socialismus.api.input.serializer.SerializationWorker;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.serializer.SerializerContent;
import me.whereareiam.socialismus.api.model.serializer.SerializerPlaceholder;
import me.whereareiam.socialismus.api.output.integration.FormattingIntegration;
import me.whereareiam.socialismus.api.output.integration.Integration;
import me.whereareiam.socialismus.api.type.SerializationType;
import me.whereareiam.socialismus.common.serializer.legacy.LegacyParsingAdapter;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.text.Component;

@Singleton
public class ComponentSerializer
implements ComponentService,
SerializationWorker,
Reloadable {
    private final Provider<Settings> settings;
    private final Provider<Messages> messages;
    private final Provider<Set<Integration>> integrations;
    private SerializationType serializationType;
    private boolean allowLegacyParsing;
    private final LinkedList<Worker<SerializerContent>> workers = new LinkedList();
    private Worker<SerializerContent> legacyWorker;

    @Inject
    public ComponentSerializer(Provider<Settings> settings, Provider<Messages> messages, Provider<Set<Integration>> integrations, Registry<Reloadable> registry) {
        this.settings = settings;
        this.messages = messages;
        this.integrations = integrations;
        this.loadSettings((Settings)settings.get());
        registry.register(this);
    }

    @Override
    public Component format(DummyPlayer dummyPlayer, String message) {
        return this.format(new SerializerContent(dummyPlayer, new ArrayList<SerializerPlaceholder>(), message));
    }

    @Override
    public Component format(SerializerContent content) {
        if (content.getMessage().isEmpty()) {
            return Component.empty();
        }
        content.setMessage(content.getMessage().replace("{prefix}", ((Messages)this.messages.get()).getPrefix()));
        if (content.getDummyPlayer().getUsername() != null) {
            content.setMessage(content.getMessage().replace("{playerName}", content.getDummyPlayer().getUsername()));
        }
        content.setMessage(this.hookIntegrations(content));
        for (SerializerPlaceholder serializerPlaceholder : content.getPlaceholders()) {
            content.setMessage(content.getMessage().replace(serializerPlaceholder.getPlaceholder(), serializerPlaceholder.getValue()));
        }
        for (Worker worker : this.workers) {
            content = (SerializerContent)worker.getFunction().apply(content);
        }
        return this.serializationType.getSerializer().deserialize((Object)content.getMessage());
    }

    @Override
    public boolean removeWorker(Worker<SerializerContent> worker) {
        if (!worker.isRemovable()) {
            return false;
        }
        return this.workers.remove(worker);
    }

    @Override
    public void addWorker(Worker<SerializerContent> worker) {
        if (this.workers.stream().anyMatch(w -> w.getPriority() == worker.getPriority())) {
            return;
        }
        this.workers.add(worker);
        this.workers.sort((a, b) -> Integer.compare(b.getPriority(), a.getPriority()));
    }

    @Override
    public void reload() {
        this.loadSettings((Settings)this.settings.get());
    }

    private void loadSettings(Settings settings) {
        this.serializationType = settings.getSerializer();
        this.allowLegacyParsing = settings.getMisc().isAllowLegacyParsing();
        this.updateLegacyWorker();
    }

    private void updateLegacyWorker() {
        if (this.allowLegacyParsing && this.legacyWorker == null) {
            this.legacyWorker = this.createLegacyWorker();
            this.addWorker(this.legacyWorker);
        }
        if (!this.allowLegacyParsing && this.legacyWorker != null) {
            this.workers.remove(this.legacyWorker);
            this.legacyWorker = null;
        }
    }

    private Worker<SerializerContent> createLegacyWorker() {
        return new Worker<SerializerContent>(this.patchLegacy(), 0, true, false);
    }

    private Function<SerializerContent, SerializerContent> patchLegacy() {
        return content -> {
            String transformed = LegacyParsingAdapter.transform(content.getMessage(), this.serializationType);
            content.setMessage(transformed);
            return content;
        };
    }

    private String hookIntegrations(SerializerContent content) {
        List<FormattingIntegration> formatters = ((Set)this.integrations.get()).stream().filter(i -> i instanceof FormattingIntegration).map(i -> (FormattingIntegration)i).toList();
        for (FormattingIntegration f : formatters) {
            if (!f.isAvailable()) continue;
            content.setMessage(f.format(content.getDummyPlayer(), content.getMessage()));
        }
        return content.getMessage();
    }

    @Override
    @Generated
    public LinkedList<Worker<SerializerContent>> getWorkers() {
        return this.workers;
    }
}

