/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.sync;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import me.whereareiam.socialismus.api.Constants;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.event.EventListener;
import me.whereareiam.socialismus.api.input.event.EventManager;
import me.whereareiam.socialismus.api.input.event.base.SocialisticEvent;
import me.whereareiam.socialismus.api.input.event.chat.history.ChatHistoryRemoveByAmountEvent;
import me.whereareiam.socialismus.api.input.event.chat.history.ChatHistoryRemoveByIdEvent;
import me.whereareiam.socialismus.api.input.event.chat.history.ChatHistoryRemoveByPlayerEvent;
import me.whereareiam.socialismus.api.input.event.chat.history.ChatHistoryRemoveEvent;
import me.whereareiam.socialismus.api.input.sync.ChatHistorySyncBus;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.output.SerializationService;
import me.whereareiam.socialismus.api.output.resource.sync.SyncService;
import me.whereareiam.socialismus.common.chat.ChatHistoryController;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ChatHistoryNetworkBridge
implements EventListener,
ChatHistorySyncBus {
    private static final String CHANNEL = "socialismus:chat-history";
    private final SyncService sync;
    private final SerializationService serializationService;
    private final ChatHistoryController chatHistoryController;
    private final Provider<ChatSettings> chatSettings;
    private final EventManager eventManager;
    private final Map<Class<? extends ChatHistoryRemoveEvent>, Consumer<ChatHistoryRemoveEvent>> eventHandlers = new HashMap<Class<? extends ChatHistoryRemoveEvent>, Consumer<ChatHistoryRemoveEvent>>();

    public void initialize() {
        if (!((ChatSettings)this.chatSettings.get()).getSynchronization().isEnabled() && !((ChatSettings)this.chatSettings.get()).getSynchronization().isClearHistory()) {
            return;
        }
        this.eventManager.register(this);
        this.initializeEventHandlers();
        this.subscribe();
    }

    private void initializeEventHandlers() {
        this.eventHandlers.put(ChatHistoryRemoveByIdEvent.class, e -> this.chatHistoryController.removeMessage(((ChatHistoryRemoveByIdEvent)e).getId(), false));
        this.eventHandlers.put(ChatHistoryRemoveByAmountEvent.class, e -> this.chatHistoryController.removeMessages(((ChatHistoryRemoveByAmountEvent)e).getAmount(), false));
        this.eventHandlers.put(ChatHistoryRemoveByPlayerEvent.class, e -> this.chatHistoryController.removeMessages(((ChatHistoryRemoveByPlayerEvent)e).getUsername(), false));
    }

    @SocialisticEvent
    public void onChatHistoryRemove(ChatHistoryRemoveEvent event) {
        if (!((ChatSettings)this.chatSettings.get()).getSynchronization().isEnabled()) {
            return;
        }
        if (Constants.IDENTIFIER.equals(event.getOrigin())) {
            this.publish(event);
        }
    }

    @Override
    public void publish(ChatHistoryRemoveEvent event) {
        try {
            byte[] data = this.serializationService.serialize(event);
            this.sync.publish(CHANNEL, data);
            Logger.debug("Published chat history event to sync channel", new Object[0]);
        }
        catch (Exception ex) {
            Logger.warn("Failed to sync chat history event: " + String.valueOf(ex), new Object[0]);
        }
    }

    @Override
    public void subscribe() {
        if (!((ChatSettings)this.chatSettings.get()).getSynchronization().isEnabled()) {
            return;
        }
        this.sync.subscribe(CHANNEL, (channel, payload) -> this.handleEvent(payload));
    }

    private void handleEvent(byte[] payload) {
        if (!((ChatSettings)this.chatSettings.get()).getSynchronization().isClearHistory()) {
            return;
        }
        try {
            ChatHistoryRemoveEvent event = this.serializationService.deserialize(payload, ChatHistoryRemoveEvent.class);
            if (Constants.IDENTIFIER.equals(event.getOrigin())) {
                return;
            }
            Logger.debug("Received chat history event from sync channel", new Object[0]);
            this.eventHandlers.getOrDefault(event.getClass(), e -> {}).accept(event);
        }
        catch (Exception ex) {
            Logger.warn("Bad chat-history-sync packet: " + String.valueOf(ex), new Object[0]);
        }
    }

    @Inject
    @Generated
    public ChatHistoryNetworkBridge(SyncService sync, SerializationService serializationService, ChatHistoryController chatHistoryController, Provider<ChatSettings> chatSettings, EventManager eventManager) {
        this.sync = sync;
        this.serializationService = serializationService;
        this.chatHistoryController = chatHistoryController;
        this.chatSettings = chatSettings;
        this.eventManager = eventManager;
    }
}

