/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.integration.papiproxybridge;

import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.integration.Integration;
import me.whereareiam.socialismus.api.output.integration.PlaceholderResolverIntegration;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.william278.papiproxybridge.api.PlaceholderAPI;

@Singleton
public class PAPIProxyBridgeIntegration
implements PlaceholderResolverIntegration {
    private Object placeholderAPI;

    @Inject
    public PAPIProxyBridgeIntegration(Registry<Integration> registry) {
        if (!this.isAvailable()) {
            return;
        }
        this.placeholderAPI = PlaceholderAPI.createInstance();
        registry.register(this);
    }

    @Override
    public String format(DummyPlayer dummyPlayer, String content) {
        if (dummyPlayer.getUniqueId() == null) {
            return content;
        }
        return ((PlaceholderAPI)this.placeholderAPI).formatPlaceholders(content, dummyPlayer.getUniqueId()).getNow(content);
    }

    @Override
    public String getName() {
        return "PAPIProxyBridge";
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("net.william278.papiproxybridge.api.PlaceholderAPI");
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }
}

