/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.library.libby.relocation;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import me.whereareiam.socialismus.library.libby.Library;
import me.whereareiam.socialismus.library.libby.LibraryManager;
import me.whereareiam.socialismus.library.libby.Util;
import me.whereareiam.socialismus.library.libby.classloader.IsolatedClassLoader;
import me.whereareiam.socialismus.library.libby.relocation.Relocation;
import org.jetbrains.annotations.NotNull;

public class RelocationHelper {
    private static final String JAR_RELOCATOR_CLASS = Util.replaceWithDots("me{}lucko{}jarrelocator{}JarRelocator");
    private static final String RELOCATION_CLASS = Util.replaceWithDots("me{}lucko{}jarrelocator{}Relocation");
    private final Constructor<?> jarRelocatorConstructor;
    private final Method jarRelocatorRunMethod;
    private final Constructor<?> relocationConstructor;

    public RelocationHelper(@NotNull LibraryManager libraryManager) {
        Objects.requireNonNull(libraryManager, "libraryManager");
        IsolatedClassLoader classLoader = new IsolatedClassLoader(new URL[0]);
        classLoader.addPath(libraryManager.downloadLibrary(Library.builder().groupId("org{}ow2{}asm").artifactId("asm-commons").version("9.7").checksumFromBase64("OJvCR5WOBJ/JoECNOYySxtNwwYA1EgOV1Muh2dkwS3o=").fallbackRepository("https://repo1.maven.org/maven2/").build()));
        classLoader.addPath(libraryManager.downloadLibrary(Library.builder().groupId("org{}ow2{}asm").artifactId("asm").version("9.7").checksumFromBase64("rfRtXjSUC98Ujs3Sap7o7qlElqcgNP9xQQZrPupcTp0=").fallbackRepository("https://repo1.maven.org/maven2/").build()));
        classLoader.addPath(libraryManager.downloadLibrary(Library.builder().groupId("com{}github{}whereareiam").artifactId("jar-relocator").version("1.8").checksumFromBase64("OWtt1tBTCRl2NHYqgfHwnGvesf6Vacup0e1kVehJuG4=").fallbackRepository("https://jitpack.io/").build()));
        try {
            Class<?> jarRelocatorClass = classLoader.loadClass(JAR_RELOCATOR_CLASS);
            Class<?> relocationClass = classLoader.loadClass(RELOCATION_CLASS);
            this.jarRelocatorConstructor = jarRelocatorClass.getConstructor(File.class, File.class, Collection.class);
            this.jarRelocatorRunMethod = jarRelocatorClass.getMethod("run", new Class[0]);
            this.relocationConstructor = relocationClass.getConstructor(String.class, String.class, Collection.class, Collection.class);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void relocate(@NotNull Path in, @NotNull Path out, @NotNull Collection<Relocation> relocations) {
        Objects.requireNonNull(in, "in");
        Objects.requireNonNull(out, "out");
        Objects.requireNonNull(relocations, "relocations");
        try {
            LinkedList rules = new LinkedList();
            for (Relocation relocation : relocations) {
                rules.add(this.relocationConstructor.newInstance(relocation.getPattern(), relocation.getRelocatedPattern(), relocation.getIncludes(), relocation.getExcludes()));
            }
            this.jarRelocatorRunMethod.invoke(this.jarRelocatorConstructor.newInstance(in.toFile(), out.toFile(), rules), new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

