/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.velocity;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.position.Position;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.type.BroadcastTarget;
import me.whereareiam.socialismus.api.type.Version;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.text.Component;

@Singleton
public class VelocityPlatformInteractor
implements PlatformInteractor {
    private final ProxyServer proxyServer;

    @Override
    public Position getPosition(DummyPlayer dummyPlayer) {
        throw new UnsupportedOperationException("Velocity does not support getting player position directly.");
    }

    @Override
    public Position getEyePosition(DummyPlayer dummyPlayer) {
        throw new UnsupportedOperationException("Velocity does not support getting player eye position directly.");
    }

    @Override
    public void broadcast(Component component, BroadcastTarget target) {
        switch (target) {
            case ALL: {
                this.proxyServer.sendMessage(component);
                break;
            }
            case PLAYERS: {
                this.proxyServer.getAllPlayers().forEach(player -> player.sendMessage(component));
                break;
            }
            case CONSOLE: {
                this.proxyServer.getConsoleCommandSource().sendMessage(component);
            }
        }
    }

    @Override
    public boolean areWithinRange(UUID player1, UUID player2, double range) {
        return this.proxyServer.getPlayer(player1).flatMap(p1 -> this.proxyServer.getPlayer(player2).flatMap(p2 -> p1.getCurrentServer().flatMap(s1 -> p2.getCurrentServer().map(arg_0 -> ((ServerConnection)s1).equals(arg_0))))).orElse(false);
    }

    @Override
    public boolean hasPermission(String username, String permission) {
        return this.proxyServer.getPlayer(username).map(value -> value.hasPermission(permission)).orElse(false);
    }

    @Override
    public boolean hasPermission(DummyPlayer dummyPlayer, String permission) {
        return this.proxyServer.getPlayer(dummyPlayer.getUniqueId()).map(value -> value.hasPermission(permission)).orElse(false);
    }

    @Override
    public List<String> getOnlinePlayers() {
        return this.proxyServer.getAllPlayers().stream().map(Player::getUsername).toList();
    }

    @Override
    public int getOnlinePlayersCount() {
        return this.proxyServer.getPlayerCount();
    }

    @Override
    public Version getServerVersion() {
        return Version.getLatest();
    }

    @Inject
    @Generated
    public VelocityPlatformInteractor(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
    }
}

