/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.velocity;

import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.api.scheduler.Scheduler;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import me.whereareiam.socialismus.api.model.scheduler.DelayedRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.PeriodicalRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.RunnableTask;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.platform.velocity.VelocitySocialismus;

@Singleton
public class VelocityScheduler
implements me.whereareiam.socialismus.api.output.Scheduler {
    private final VelocitySocialismus socialismus;
    private final Scheduler velocityScheduler;
    private final Map<String, Map<Integer, ScheduledTask>> tasks = new ConcurrentHashMap<String, Map<Integer, ScheduledTask>>();
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(1);

    @Inject
    public VelocityScheduler(VelocitySocialismus socialismus, ProxyServer proxyServer) {
        this.socialismus = socialismus;
        this.velocityScheduler = proxyServer.getScheduler();
    }

    private int ensureId(RunnableTask task) {
        int existing = task.getId();
        if (existing <= 0) {
            int id = ID_GENERATOR.getAndIncrement();
            task.setId(id);
            return id;
        }
        return existing;
    }

    @Override
    public void schedule(RunnableTask runnableTask) {
        int id = this.ensureId(runnableTask);
        ScheduledTask task = this.velocityScheduler.buildTask((Object)this.socialismus, runnableTask.getRunnable()).schedule();
        this.tasks.computeIfAbsent(runnableTask.getModule(), m -> new ConcurrentHashMap()).put(id, task);
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask) {
        int id = this.ensureId(runnableTask);
        ScheduledTask task = this.velocityScheduler.buildTask((Object)this.socialismus, runnableTask.getRunnable()).delay(Duration.ofMillis(runnableTask.getDelay())).schedule();
        this.tasks.computeIfAbsent(runnableTask.getModule(), m -> new ConcurrentHashMap()).put(id, task);
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask) {
        int id = this.ensureId(runnableTask);
        ScheduledTask task = this.velocityScheduler.buildTask((Object)this.socialismus, runnableTask.getRunnable()).delay(Duration.ofMillis(runnableTask.getDelay())).repeat(Duration.ofMillis(runnableTask.getPeriod())).schedule();
        this.tasks.computeIfAbsent(runnableTask.getModule(), m -> new ConcurrentHashMap()).put(id, task);
    }

    @Override
    public void schedule(RunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void cancel(RunnableTask runnableTask) {
        Map<Integer, ScheduledTask> moduleTasks = this.tasks.get(runnableTask.getModule());
        if (moduleTasks != null) {
            Integer id = runnableTask.getId();
            ScheduledTask task = moduleTasks.remove(id);
            if (task != null) {
                task.cancel();
            }
            if (moduleTasks.isEmpty()) {
                this.tasks.remove(runnableTask.getModule());
            }
        }
    }

    @Override
    public void cancel(DelayedRunnableTask runnableTask) {
        this.cancel((RunnableTask)runnableTask);
    }

    @Override
    public void cancelByModule(String module) {
        Map<Integer, ScheduledTask> moduleTasks = this.tasks.remove(module);
        if (moduleTasks != null) {
            moduleTasks.values().forEach(ScheduledTask::cancel);
        }
    }
}

