/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.velocity;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import jakarta.inject.Inject;
import java.nio.file.Path;
import lombok.Generated;
import me.whereareiam.socialismus.api.type.PluginType;
import me.whereareiam.socialismus.common.CommonInjector;
import me.whereareiam.socialismus.common.CommonSocialismus;
import me.whereareiam.socialismus.common.IntegrityChecker;
import me.whereareiam.socialismus.integration.bstats.bStatsIntegration;
import me.whereareiam.socialismus.integration.packetevents.PacketEventsIntegration;
import me.whereareiam.socialismus.integration.papiproxybridge.PAPIProxyBridgeIntegration;
import me.whereareiam.socialismus.platform.velocity.VelocityDependencyResolver;
import me.whereareiam.socialismus.platform.velocity.VelocityLoggingHelper;
import me.whereareiam.socialismus.platform.velocity.inject.VelocityInjector;
import org.slf4j.Logger;

@Plugin(id="socialismus", name="Socialismus", version="2.0.0-RC4", authors={"whereareiam"}, dependencies={@Dependency(id="packetevents", optional=true), @Dependency(id="papiproxybridge", optional=true)})
public class VelocitySocialismus {
    private final CommonSocialismus commonSocialismus = new CommonSocialismus();
    private final ProxyServer proxyServer;
    private final PluginContainer pluginContainer;
    private final Logger logger;
    private final Path dataPath;

    @Inject
    public VelocitySocialismus(ProxyServer proxyServer, PluginContainer pluginContainer, Logger logger, @DataDirectory Path dataPath) {
        this.proxyServer = proxyServer;
        this.pluginContainer = pluginContainer;
        this.logger = logger;
        this.dataPath = dataPath;
    }

    @Subscribe
    public void onProxyInitializationEvent(ProxyInitializeEvent event) {
        PluginType.setPluginType(PluginType.VELOCITY);
        VelocityLoggingHelper.setLogger(this.logger);
        VelocityDependencyResolver dependencyResolver = new VelocityDependencyResolver(this, this.logger, this.dataPath, this.proxyServer.getPluginManager());
        dependencyResolver.loadLibraries();
        dependencyResolver.resolveDependencies();
        new VelocityInjector(this, this.pluginContainer, this.proxyServer, dependencyResolver, this.dataPath);
        this.commonSocialismus.onLoad();
        if (((IntegrityChecker)CommonInjector.getInjector().getInstance(IntegrityChecker.class)).checkIntegrity()) {
            throw new RuntimeException("Integrity check failed, plugin will be disabled");
        }
        CommonInjector.getInjector().getInstance(PAPIProxyBridgeIntegration.class);
        CommonInjector.getInjector().getInstance(PacketEventsIntegration.class);
        CommonInjector.getInjector().getInstance(bStatsIntegration.class);
        this.commonSocialismus.onEnable();
    }

    @Subscribe
    public void onProxyShutdownEvent(ProxyShutdownEvent event) {
        this.commonSocialismus.onDisable();
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }
}

