/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.velocity.listener.chat;

import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.output.listener.DynamicListener;
import me.whereareiam.socialismus.common.chat.ChatCoordinator;
import me.whereareiam.socialismus.common.chat.ChatMessageFactory;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

@Singleton
public class PlayerChatListener
implements DynamicListener<PlayerChatEvent> {
    private final ProxyServer proxyServer;
    private final ChatCoordinator chatCoordinator;
    private final ChatMessageFactory chatMessageFactory;

    @Override
    public void onEvent(PlayerChatEvent event) {
        Player player = event.getPlayer();
        Collection recipients = this.proxyServer.getAllPlayers();
        TextComponent content = Component.text((String)event.getMessage());
        ChatMessage chatMessage = this.chatMessageFactory.createChatMessage(player.getUniqueId(), recipients.stream().map(Player::getUniqueId).collect(Collectors.toSet()), (Component)content);
        this.chatCoordinator.coordinate(chatMessage);
        event.setResult(PlayerChatEvent.ChatResult.denied());
    }

    @Inject
    @Generated
    public PlayerChatListener(ProxyServer proxyServer, ChatCoordinator chatCoordinator, ChatMessageFactory chatMessageFactory) {
        this.proxyServer = proxyServer;
        this.chatCoordinator = chatCoordinator;
        this.chatMessageFactory = chatMessageFactory;
    }
}

