/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.velocity.mapper;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.whereareiam.socialismus.api.input.container.PlayerContainerService;
import me.whereareiam.socialismus.api.model.player.DummyCommandPlayer;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.audience.Audience;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.SenderMapper;

@Singleton
public class CommandSourceMapper
implements SenderMapper<CommandSource, DummyPlayer> {
    private final PlayerContainerService playerContainer;

    @Inject
    public CommandSourceMapper(PlayerContainerService playerContainer) {
        this.playerContainer = playerContainer;
    }

    public @NonNull DummyPlayer map(@NonNull CommandSource source) {
        if (source instanceof ConsoleCommandSource) {
            return ((DummyCommandPlayer.DummyCommandPlayerBuilder)((DummyPlayer.DummyPlayerBuilder)DummyCommandPlayer.builder().commandSender(source)).audience((Audience)source)).build();
        }
        Player player = (Player)source;
        Optional<DummyPlayer> dummyPlayer = this.playerContainer.getPlayer(player.getUniqueId());
        if (dummyPlayer.isPresent()) {
            return DummyCommandPlayer.from(dummyPlayer.get(), source);
        }
        throw new NullPointerException("A player with the name " + player.getUsername() + " was not found");
    }

    @Nonnull
    public CommandSource reverse(@Nonnull DummyPlayer dummyPlayer) {
        return (CommandSource)((DummyCommandPlayer)dummyPlayer).getCommandSender();
    }
}

