/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import me.whereareiam.socialismus.adapter.config.adapter.SerializationServiceAdapter;
import me.whereareiam.socialismus.adapter.config.dynamic.ChatsConfig;
import me.whereareiam.socialismus.adapter.config.management.DefaultConfigurationLoader;
import me.whereareiam.socialismus.adapter.config.management.DefaultConfigurationManager;
import me.whereareiam.socialismus.adapter.config.management.DefaultConfigurationMerger;
import me.whereareiam.socialismus.adapter.config.management.DefaultConfigurationSaver;
import me.whereareiam.socialismus.adapter.config.management.DefaultObjectMapperRegistry;
import me.whereareiam.socialismus.adapter.config.provider.CommandsProvider;
import me.whereareiam.socialismus.adapter.config.provider.MessagesProvider;
import me.whereareiam.socialismus.adapter.config.provider.SettingsProvider;
import me.whereareiam.socialismus.adapter.config.provider.base.CoreJacksonModuleProvider;
import me.whereareiam.socialismus.adapter.config.provider.base.ObjectMapperProvider;
import me.whereareiam.socialismus.adapter.config.provider.chat.ChatMessagesProvider;
import me.whereareiam.socialismus.adapter.config.provider.chat.ChatSettingsProvider;
import me.whereareiam.socialismus.adapter.config.provider.chat.ChatsProvider;
import me.whereareiam.socialismus.adapter.config.resolver.FileSystemConfigurationTypeResolver;
import me.whereareiam.socialismus.adapter.config.template.CommandsTemplate;
import me.whereareiam.socialismus.adapter.config.template.MessagesTemplate;
import me.whereareiam.socialismus.adapter.config.template.SettingsTemplate;
import me.whereareiam.socialismus.adapter.config.template.chat.ChatMessagesTemplate;
import me.whereareiam.socialismus.adapter.config.template.chat.ChatSettingsTemplate;
import me.whereareiam.socialismus.adapter.config.template.chat.ChatTemplate;
import me.whereareiam.socialismus.api.input.registry.ObjectMapperRegistry;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.model.chat.Chat;
import me.whereareiam.socialismus.api.model.chat.ChatMessages;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.config.Commands;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.api.output.DefaultConfig;
import me.whereareiam.socialismus.api.output.SerializationService;
import me.whereareiam.socialismus.api.output.config.ConfigurationLoader;
import me.whereareiam.socialismus.api.output.config.ConfigurationManager;
import me.whereareiam.socialismus.api.output.config.ConfigurationMerger;
import me.whereareiam.socialismus.api.output.config.ConfigurationSaver;
import me.whereareiam.socialismus.api.output.config.ConfigurationTypeResolver;
import me.whereareiam.socialismus.library.guice.AbstractModule;
import me.whereareiam.socialismus.library.guice.Binder;
import me.whereareiam.socialismus.library.guice.TypeLiteral;
import me.whereareiam.socialismus.library.guice.multibindings.MapBinder;
import me.whereareiam.socialismus.library.guice.multibindings.Multibinder;
import me.whereareiam.socialismus.library.guice.name.Names;
import me.whereareiam.socialismus.library.jackson.databind.Module;
import me.whereareiam.socialismus.library.jackson.databind.ObjectMapper;

public class ConfigBinder
extends AbstractModule {
    private final Path dataPath;
    private final Path modulesPath;
    private final Path chatPath;

    public ConfigBinder(Path dataPath) {
        this.dataPath = dataPath;
        this.modulesPath = dataPath.resolve("modules");
        this.chatPath = dataPath.resolve("chats");
    }

    protected void configure() {
        this.bind(ConfigurationTypeResolver.class).to(FileSystemConfigurationTypeResolver.class).asEagerSingleton();
        this.bind(Path.class).toInstance((Object)this.dataPath);
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"dataPath")).toInstance((Object)this.dataPath);
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"modulesPath")).toInstance((Object)this.modulesPath);
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"chatPath")).toInstance((Object)this.chatPath);
        this.createDirectories();
        this.bind(SerializationService.class).to(SerializationServiceAdapter.class);
        this.bind(ConfigurationManager.class).to(DefaultConfigurationManager.class);
        this.bind(ConfigurationLoader.class).to(DefaultConfigurationLoader.class);
        this.bind(ConfigurationSaver.class).to(DefaultConfigurationSaver.class);
        this.bind(ConfigurationMerger.class).to(DefaultConfigurationMerger.class);
        this.bind(ObjectMapperRegistry.class).to(DefaultObjectMapperRegistry.class).asEagerSingleton();
        Multibinder moduleBinder = Multibinder.newSetBinder((Binder)this.binder(), Module.class);
        moduleBinder.addBinding().toProvider(CoreJacksonModuleProvider.class).asEagerSingleton();
        this.bind(ObjectMapper.class).toProvider(ObjectMapperProvider.class).asEagerSingleton();
        MapBinder mapbinder = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<DefaultConfig<?>>(){}, (Annotation)Names.named((String)"configTemplates"));
        this.addTemplates(mapbinder);
        this.bind(SettingsProvider.class);
        this.bind(Settings.class).toProvider(SettingsProvider.class);
        this.bind(MessagesProvider.class);
        this.bind(Messages.class).toProvider(MessagesProvider.class);
        this.bind(CommandsProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Map<String, CommandEntity>>(){}).toProvider(CommandsProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Registry<Map<String, CommandEntity>>>(){}).to(CommandsProvider.class).asEagerSingleton();
        this.bind(ChatsProvider.class).asEagerSingleton();
        this.bind((TypeLiteral)new TypeLiteral<List<Chat>>(){}).annotatedWith((Annotation)Names.named((String)"chats")).toProvider(ChatsProvider.class);
        this.bind(ChatSettingsProvider.class).asEagerSingleton();
        this.bind(ChatSettings.class).toProvider(ChatSettingsProvider.class);
        this.bind(ChatMessagesProvider.class).asEagerSingleton();
        this.bind(ChatMessages.class).toProvider(ChatMessagesProvider.class);
    }

    private void addTemplates(MapBinder<Class<?>, DefaultConfig<?>> mapbinder) {
        mapbinder.addBinding(Settings.class).to(SettingsTemplate.class);
        mapbinder.addBinding(Messages.class).to(MessagesTemplate.class);
        mapbinder.addBinding(Commands.class).to(CommandsTemplate.class);
        mapbinder.addBinding(ChatMessages.class).to(ChatMessagesTemplate.class);
        mapbinder.addBinding(ChatSettings.class).to(ChatSettingsTemplate.class);
        mapbinder.addBinding(ChatsConfig.class).to(ChatTemplate.class);
    }

    private void createDirectories() {
        try {
            Files.createDirectories(this.dataPath, new FileAttribute[0]);
            Files.createDirectories(this.modulesPath, new FileAttribute[0]);
            Files.createDirectories(this.chatPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create directories", e);
        }
    }
}

