/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.management;

import lombok.Generated;
import me.whereareiam.socialismus.api.output.config.ConfigurationMerger;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.jackson.databind.JsonNode;
import me.whereareiam.socialismus.library.jackson.databind.ObjectMapper;
import me.whereareiam.socialismus.library.jackson.databind.node.ObjectNode;

@Singleton
public class DefaultConfigurationMerger
implements ConfigurationMerger {
    private final ObjectMapper objectMapper;

    @Override
    public <T> void merge(T config, T defaultConfig) {
        try {
            ObjectNode configNode = (ObjectNode)this.objectMapper.valueToTree(config);
            JsonNode defaultConfigNode = this.objectMapper.valueToTree(defaultConfig);
            this.mergeNodes(configNode, defaultConfigNode);
            this.objectMapper.readerForUpdating(config).readValue((JsonNode)configNode);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to merge configuration", e);
        }
    }

    private void mergeNodes(ObjectNode configNode, JsonNode defaultConfigNode) {
        defaultConfigNode.properties().forEach(entry -> {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (!configNode.has(key) || configNode.get(key).isNull()) {
                configNode.set(key, value);
            } else if (configNode.get(key).isObject() && value.isObject()) {
                this.mergeNodes((ObjectNode)configNode.get(key), value);
            }
        });
    }

    @Inject
    @Generated
    public DefaultConfigurationMerger(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

