/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.provider.chat;

import java.nio.file.Path;
import me.whereareiam.socialismus.adapter.config.management.DefaultConfigurationLoader;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class ChatSettingsProvider
implements Provider<ChatSettings>,
Reloadable {
    private final Path dataPath;
    private final DefaultConfigurationLoader defaultConfigurationLoader;
    private ChatSettings chatSettings;

    @Inject
    public ChatSettingsProvider(@Named(value="chatPath") Path dataPath, DefaultConfigurationLoader defaultConfigurationLoader, Registry<Reloadable> registry) {
        this.dataPath = dataPath;
        this.defaultConfigurationLoader = defaultConfigurationLoader;
        registry.register(this);
    }

    public ChatSettings get() {
        if (this.chatSettings != null) {
            return this.chatSettings;
        }
        this.load();
        return this.chatSettings;
    }

    @Override
    public void reload() {
        this.load();
    }

    private void load() {
        this.chatSettings = this.defaultConfigurationLoader.load(this.dataPath.resolve("settings"), ChatSettings.class);
    }
}

