/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.module;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.output.resource.ResourceRegistry;
import me.whereareiam.socialismus.api.type.ResourceType;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ResourceRegistryAdapter
implements ResourceRegistry {
    private final Map<ResourceType, Object> resources = new ConcurrentHashMap<ResourceType, Object>();

    @Override
    public <T> void register(ResourceType type, T impl) {
        this.resources.computeIfAbsent(type, key -> {
            Logger.info("Registered resource " + String.valueOf((Object)type) + " \u2192 " + impl.getClass().getSimpleName(), new Object[0]);
            return impl;
        });
    }

    @Override
    public <T> Optional<T> get(ResourceType type) {
        return Optional.ofNullable(this.resources.get((Object)type));
    }

    @Override
    public boolean has(ResourceType type) {
        return this.resources.containsKey((Object)type);
    }

    @Override
    public void unregister(ResourceType type) {
        this.resources.remove((Object)type);
    }
}

