/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.api.util;

import lombok.Generated;
import me.whereareiam.socialismus.library.adventure.text.Component;
import me.whereareiam.socialismus.library.adventure.text.minimessage.MiniMessage;
import me.whereareiam.socialismus.library.adventure.text.serializer.gson.GsonComponentSerializer;
import me.whereareiam.socialismus.library.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.whereareiam.socialismus.library.adventure.text.serializer.plain.PlainTextComponentSerializer;

public class ComponentUtil {
    private static final PlainTextComponentSerializer PLAIN_TEXT_SERIALIZER = PlainTextComponentSerializer.plainText();
    private static final MiniMessage MINI_MESSAGE_SERIALIZER = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacyAmpersand();
    private static final LegacyComponentSerializer LEGACY_SECTION_SERIALIZER = LegacyComponentSerializer.legacySection();
    private static final GsonComponentSerializer GSON_SERIALIZER = GsonComponentSerializer.gson();
    private static final GsonComponentSerializer GSON_DOWNSAMPLING_SERIALIZER = GsonComponentSerializer.colorDownsamplingGson();

    public static String toPlain(Component component) {
        return PLAIN_TEXT_SERIALIZER.serialize(component);
    }

    public static String toLegacy(Component component) {
        return ComponentUtil.toLegacy(component, false);
    }

    public static String toLegacy(Component component, boolean section) {
        if (section) {
            return LEGACY_SECTION_SERIALIZER.serialize(component);
        }
        return LEGACY_SERIALIZER.serialize(component);
    }

    public static Component toMiniMessage(String string) {
        return MINI_MESSAGE_SERIALIZER.deserialize((Object)string);
    }

    public static Component toGson(String string) {
        return ComponentUtil.toGson(string, false);
    }

    public static Component toGson(String string, boolean downsampling) {
        if (downsampling) {
            return GSON_DOWNSAMPLING_SERIALIZER.deserialize((Object)string);
        }
        return GSON_SERIALIZER.deserialize((Object)string);
    }

    public static String toGson(Component component) {
        return (String)GSON_SERIALIZER.serialize(component);
    }

    @Generated
    public static PlainTextComponentSerializer getPLAIN_TEXT_SERIALIZER() {
        return PLAIN_TEXT_SERIALIZER;
    }

    @Generated
    public static MiniMessage getMINI_MESSAGE_SERIALIZER() {
        return MINI_MESSAGE_SERIALIZER;
    }

    @Generated
    public static LegacyComponentSerializer getLEGACY_SERIALIZER() {
        return LEGACY_SERIALIZER;
    }

    @Generated
    public static LegacyComponentSerializer getLEGACY_SECTION_SERIALIZER() {
        return LEGACY_SECTION_SERIALIZER;
    }

    @Generated
    public static GsonComponentSerializer getGSON_SERIALIZER() {
        return GSON_SERIALIZER;
    }

    @Generated
    public static GsonComponentSerializer getGSON_DOWNSAMPLING_SERIALIZER() {
        return GSON_DOWNSAMPLING_SERIALIZER;
    }
}

