/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.builder;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.config.message.CommandMessages;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.command.builder.PaginationBuilder;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.incendo.cloud.Command;
import org.incendo.cloud.component.CommandComponent;

@Singleton
public class HelpBuilder {
    private final Provider<Settings> settings;
    private final Provider<Messages> messages;
    private final PaginationBuilder paginationBuilder;

    @Inject
    public HelpBuilder(Provider<Settings> settings, Provider<Messages> messages, PaginationBuilder paginationBuilder) {
        this.settings = settings;
        this.messages = messages;
        this.paginationBuilder = paginationBuilder;
    }

    public String buildHelpMessage(Collection<Command<DummyPlayer>> allowedCommands, int page) {
        String message = String.join((CharSequence)"\n", ((Messages)this.messages.get()).getCommands().getHelpCommand().getFormat());
        if (message.contains("{commands}")) {
            message = this.buildCommandList(allowedCommands, message, page);
        }
        if (message.contains("{pagination}")) {
            message = this.paginationBuilder.build(message, allowedCommands.size(), page);
        }
        return message;
    }

    private String buildCommandList(Collection<Command<DummyPlayer>> commands, String message, int page) {
        if (commands.isEmpty()) {
            return message.replace("{commands}", ((Messages)this.messages.get()).getCommands().getHelpCommand().getNoCommands());
        }
        long skip = (long)(page - 1) * (long)((Settings)this.settings.get()).getMisc().getCommandsPerPage();
        List commandDescriptions = commands.stream().skip(skip).limit(((Settings)this.settings.get()).getMisc().getCommandsPerPage()).map(command -> {
            String commandFormat = ((Messages)this.messages.get()).getCommands().getHelpCommand().getCommandFormat();
            return commandFormat.replace("{command}", command.rootComponent().name()).replace("{arguments}", this.formatCommandArguments(command.rootComponent().name(), command.nonFlagArguments())).replace("{description}", command.commandDescription().description().textDescription());
        }).collect(Collectors.toList());
        String commandsString = String.join((CharSequence)"\n", commandDescriptions);
        return message.replace("{commands}", commandsString);
    }

    private String formatCommandArguments(String commandName, List<? extends CommandComponent<?>> arguments) {
        if (arguments.isEmpty()) {
            return "";
        }
        CommandMessages commandMessages = ((Messages)this.messages.get()).getCommands();
        CommandMessages.Format messageFormat = ((Messages)this.messages.get()).getCommands().getFormat();
        return arguments.parallelStream().skip(1L).map(argument -> switch (argument.type()) {
            case CommandComponent.ComponentType.REQUIRED_VARIABLE -> messageFormat.getArgument().replace("{argument}", commandMessages.getArguments().get(argument.name()) != null ? (CharSequence)commandMessages.getArguments().get(argument.name()) : argument.name());
            case CommandComponent.ComponentType.OPTIONAL_VARIABLE -> messageFormat.getOptionalArgument().replace("{argument}", commandMessages.getArguments().get(argument.name()) != null ? (CharSequence)commandMessages.getArguments().get(argument.name()) : argument.name());
            default -> commandMessages.getArguments().get(argument.name()) != null ? commandMessages.getArguments().get(argument.name()) : argument.name();
        }).collect(Collectors.collectingAndThen(Collectors.joining(" "), formattedArguments -> formattedArguments.isEmpty() ? "" : " " + formattedArguments));
    }
}

