/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.executor;

import java.util.Map;
import java.util.Set;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.input.event.plugin.PluginReloadedEvent;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.model.config.message.CommandMessages;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.command.CommandBase;
import me.whereareiam.socialismus.api.output.command.CommandCooldown;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.library.adventure.audience.Audience;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.CommandDescription;
import org.incendo.cloud.annotations.Permission;

@Singleton
public class ReloadCommand
extends CommandBase {
    private static final String COMMAND_NAME = "reload";
    private final Provider<Map<String, CommandEntity>> commands;
    private final Set<Reloadable> reloadables;
    private final Provider<Messages> messages;

    @Inject
    public ReloadCommand(Provider<Map<String, CommandEntity>> commands, @Named(value="reloadables") Set<Reloadable> reloadables, Provider<Messages> messages) {
        super(COMMAND_NAME);
        this.commands = commands;
        this.reloadables = reloadables;
        this.messages = messages;
    }

    @Command(value="%command.reload")
    @CommandDescription(value="%description.reload")
    @CommandCooldown(value="%cooldown.reload")
    @Permission(value={"%permission.reload"})
    public void onCommand(DummyPlayer dummyPlayer) {
        Audience audience = dummyPlayer.getAudience();
        Messages messages = (Messages)this.messages.get();
        CommandMessages.ReloadCommand commandMessages = messages.getCommands().getReloadCommand();
        audience.sendMessage(Serializer.serialize(dummyPlayer, commandMessages.getReloading()));
        try {
            if (EventUtil.callEvent(new PluginReloadedEvent(false), () -> this.reloadables.forEach(Reloadable::reload))) {
                audience.sendMessage(Serializer.serialize(dummyPlayer, commandMessages.getReloaded()));
            } else {
                audience.sendMessage(Serializer.serialize(dummyPlayer, messages.getCommands().getCancelled()));
            }
        }
        catch (Exception e) {
            audience.sendMessage(Serializer.serialize(dummyPlayer, commandMessages.getException().replace("{exception}", e.getMessage())));
        }
    }

    @Override
    public CommandEntity getCommandEntity() {
        return (CommandEntity)((Map)this.commands.get()).get(COMMAND_NAME);
    }
}

