/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.management;

import java.util.List;
import lombok.Generated;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.model.config.message.CommandMessages;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.serializer.SerializerContent;
import me.whereareiam.socialismus.api.model.serializer.SerializerPlaceholder;
import me.whereareiam.socialismus.library.adventure.text.Component;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.incendo.cloud.exception.ArgumentParseException;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.InvalidCommandSenderException;
import org.incendo.cloud.exception.InvalidSyntaxException;
import org.incendo.cloud.exception.NoPermissionException;
import org.incendo.cloud.exception.handling.ExceptionContext;
import org.incendo.cloud.exception.parsing.NumberParseException;
import org.incendo.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import org.incendo.cloud.parser.standard.BooleanParser;
import org.incendo.cloud.parser.standard.StringParser;

@Singleton
public class CommandExceptionHandler {
    private final Provider<Messages> messages;

    public Component handleParseException(ComponentCaptionFormatter<DummyPlayer> formatter, ExceptionContext<DummyPlayer, ArgumentParseException> exception) {
        DummyPlayer player = (DummyPlayer)exception.context().sender();
        CommandMessages commandMessages = ((Messages)this.messages.get()).getCommands();
        Throwable throwable = ((ArgumentParseException)exception.exception()).getCause();
        if (throwable instanceof BooleanParser.BooleanParseException) {
            BooleanParser.BooleanParseException e = (BooleanParser.BooleanParseException)throwable;
            return this.getFormattedMessage(player, commandMessages.getInvalidSyntaxBoolean(), e.input());
        }
        throwable = ((ArgumentParseException)exception.exception()).getCause();
        if (throwable instanceof NumberParseException) {
            NumberParseException e = (NumberParseException)throwable;
            return this.getFormattedMessage(player, commandMessages.getInvalidSyntaxNumber(), e.input());
        }
        throwable = ((ArgumentParseException)exception.exception()).getCause();
        if (throwable instanceof StringParser.StringParseException) {
            StringParser.StringParseException e = (StringParser.StringParseException)throwable;
            return this.getFormattedMessage(player, commandMessages.getInvalidSyntaxString(), e.input());
        }
        return Component.text((String)("Unknown parse exception occurred" + ((ArgumentParseException)exception.exception()).getCause().getMessage()));
    }

    public Component handleInvalidCommandSenderException(ComponentCaptionFormatter<DummyPlayer> formatter, ExceptionContext<DummyPlayer, InvalidCommandSenderException> exception) {
        return Component.text((String)"Unknown sender exception occurred");
    }

    public Component handleNoPermissionException(ComponentCaptionFormatter<DummyPlayer> formatter, ExceptionContext<DummyPlayer, NoPermissionException> exception) {
        return this.getFormattedMessage((DummyPlayer)exception.context().sender(), ((Messages)this.messages.get()).getCommands().getNoPermission(), ((NoPermissionException)exception.exception()).missingPermission().permissionString());
    }

    public Component handleInvalidSyntaxException(ComponentCaptionFormatter<DummyPlayer> formatter, ExceptionContext<DummyPlayer, InvalidSyntaxException> exception) {
        return this.getFormattedMessage((DummyPlayer)exception.context().sender(), ((Messages)this.messages.get()).getCommands().getInvalidSyntax(), ((InvalidSyntaxException)exception.exception()).correctSyntax().replace("|", "/"));
    }

    public Component handleCommandExecutionException(ComponentCaptionFormatter<DummyPlayer> formatter, ExceptionContext<DummyPlayer, CommandExecutionException> exception) {
        ((CommandExecutionException)exception.exception()).printStackTrace();
        return this.getFormattedMessage((DummyPlayer)exception.context().sender(), ((Messages)this.messages.get()).getCommands().getExecutionError(), ((CommandExecutionException)exception.exception()).getMessage());
    }

    private Component getFormattedMessage(DummyPlayer dummyPlayer, String message, String content) {
        return Serializer.serialize(new SerializerContent(dummyPlayer, List.of(new SerializerPlaceholder("{content}", content)), message));
    }

    @Inject
    @Generated
    public CommandExceptionHandler(Provider<Messages> messages) {
        this.messages = messages;
    }
}

