/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.management;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.command.CommandBase;
import me.whereareiam.socialismus.api.output.command.CommandCooldown;
import me.whereareiam.socialismus.api.output.command.CommandService;
import me.whereareiam.socialismus.command.executor.ClearCommand;
import me.whereareiam.socialismus.command.executor.DebugCommand;
import me.whereareiam.socialismus.command.executor.HelpCommand;
import me.whereareiam.socialismus.command.executor.MainCommand;
import me.whereareiam.socialismus.command.executor.ReloadCommand;
import me.whereareiam.socialismus.command.listener.CommandCooldownListener;
import me.whereareiam.socialismus.command.management.CommandTranslator;
import me.whereareiam.socialismus.command.provider.CrossPlayerProvider;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Injector;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.annotations.string.StringProcessor;
import org.incendo.cloud.execution.postprocessor.CommandPostprocessor;
import org.incendo.cloud.processors.cooldown.Cooldown;
import org.incendo.cloud.processors.cooldown.CooldownConfiguration;
import org.incendo.cloud.processors.cooldown.CooldownGroup;
import org.incendo.cloud.processors.cooldown.CooldownManager;
import org.incendo.cloud.processors.cooldown.CooldownRepository;
import org.incendo.cloud.processors.cooldown.DurationFunction;
import org.incendo.cloud.processors.cooldown.ImmutableCooldownConfiguration;
import org.incendo.cloud.processors.cooldown.annotation.CooldownBuilderModifier;
import org.incendo.cloud.processors.cooldown.listener.CooldownActiveListener;
import org.incendo.cloud.processors.cooldown.listener.CooldownCreationListener;
import org.incendo.cloud.processors.cooldown.listener.ScheduledCleanupCreationListener;

@Singleton
public class CommandProcessor
implements CommandService {
    private final Injector injector;
    private final Provider<CommandManager<DummyPlayer>> commandManager;
    private final AnnotationParser<DummyPlayer> annotationParser;
    private final Map<String, String> translations = new HashMap<String, String>();

    @Inject
    public CommandProcessor(Injector injector, Provider<CommandManager<DummyPlayer>> commandManager, Provider<Map<String, CommandEntity>> commands) {
        this.injector = injector;
        this.commandManager = commandManager;
        this.annotationParser = new AnnotationParser((CommandManager)commandManager.get(), DummyPlayer.class);
        this.annotationParser.stringProcessor((StringProcessor)((CommandTranslator)injector.getInstance(CommandTranslator.class)).getProcessor());
        this.annotationParser.registerBuilderModifier(CommandCooldown.class, (annotation, builder) -> {
            CommandEntity entity = (CommandEntity)((Map)commands.get()).get(annotation.value().split("\\.")[1]);
            if (entity == null || !entity.getCooldown().isEnabled()) {
                return builder;
            }
            Cooldown cooldown = Cooldown.of((DurationFunction)DurationFunction.constant((Duration)Duration.ofSeconds(entity.getCooldown().getDuration())), (CooldownGroup)CooldownGroup.named((String)entity.getCooldown().getGroup()));
            return builder.apply((Command.Builder.Applicable)cooldown);
        });
        this.annotationParser.parse(new Object[]{injector.getInstance(CrossPlayerProvider.class)});
        CooldownBuilderModifier.install(this.annotationParser);
        ((CommandManager)commandManager.get()).registerCommandPostProcessor(this.createCooldownManager());
    }

    @Override
    public void initialize() {
        CommandManager commandManager = (CommandManager)this.commandManager.get();
        commandManager.rootCommands().forEach(arg_0 -> ((CommandManager)commandManager).deleteRootCommand(arg_0));
        Stream.of((CommandBase)this.injector.getInstance(MainCommand.class), (CommandBase)this.injector.getInstance(HelpCommand.class), (CommandBase)this.injector.getInstance(DebugCommand.class), (CommandBase)this.injector.getInstance(ReloadCommand.class), (CommandBase)this.injector.getInstance(ClearCommand.class)).forEach(this::registerCommand);
    }

    private CommandPostprocessor<DummyPlayer> createCooldownManager() {
        CooldownRepository repository = CooldownRepository.mapping(DummyPlayer::getUniqueId, (CooldownRepository)CooldownRepository.forMap(new HashMap()));
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        ImmutableCooldownConfiguration configuration = CooldownConfiguration.builder().repository(repository).addActiveCooldownListener((CooldownActiveListener)this.injector.getInstance(CommandCooldownListener.class)).addCreationListener((CooldownCreationListener)new ScheduledCleanupCreationListener(executorService, repository)).build();
        CooldownManager cooldownManager = CooldownManager.cooldownManager((CooldownConfiguration)configuration);
        return cooldownManager.createPostprocessor();
    }

    @Override
    public void registerCommand(CommandBase command) {
        this.translations.putAll(command.getTranslations());
        this.annotationParser.parse(new Object[]{command});
    }

    @Override
    public void registerTranslation(String key, String value) {
        this.translations.put(key, value);
    }

    @Override
    public int getCommandCount() {
        return ((CommandManager)this.commandManager.get()).commands().size();
    }

    @Override
    public String getTranslation(String key) {
        return this.translations.get(key);
    }

    @Override
    public Map<String, String> getTranslations() {
        return this.translations;
    }
}

