/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import me.whereareiam.socialismus.api.Constants;
import me.whereareiam.socialismus.api.input.chat.ChatHistoryService;
import me.whereareiam.socialismus.api.input.container.ChatHistoryContainerService;
import me.whereareiam.socialismus.api.input.event.chat.history.ChatHistoryRemoveByAmountEvent;
import me.whereareiam.socialismus.api.input.event.chat.history.ChatHistoryRemoveByIdEvent;
import me.whereareiam.socialismus.api.input.event.chat.history.ChatHistoryRemoveByPlayerEvent;
import me.whereareiam.socialismus.api.input.event.chat.history.ChatHistoryRemoveEvent;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.type.BroadcastTarget;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.common.chat.broadcast.ChatBroadcaster;
import me.whereareiam.socialismus.library.adventure.text.Component;
import me.whereareiam.socialismus.library.adventure.text.TextComponent;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ChatHistoryController
implements ChatHistoryService {
    private final ChatHistoryContainerService chatHistoryContainer;
    private final Provider<ChatSettings> chatSettings;
    private final ChatBroadcaster chatBroadcaster;
    private final PlatformInteractor interactor;

    @Override
    public boolean removeMessage(int id) {
        return this.removeMessage(id, true);
    }

    @Override
    public boolean removeMessage(int id, boolean callEvent) {
        return this.processRemoval(() -> this.chatHistoryContainer.removeMessage(id), () -> new ChatHistoryRemoveByIdEvent(Constants.IDENTIFIER, id), callEvent);
    }

    @Override
    public int removeMessages(int amount) {
        return this.removeMessages(amount, true);
    }

    @Override
    public int removeMessages(int amount, boolean callEvent) {
        return this.processRemoval(() -> this.chatHistoryContainer.removeMessages(amount) > 0, () -> new ChatHistoryRemoveByAmountEvent(Constants.IDENTIFIER, amount), callEvent) ? 1 : 0;
    }

    @Override
    public int removeMessages(String username) {
        return this.removeMessages(username, true);
    }

    @Override
    public int removeMessages(String username, boolean callEvent) {
        return this.processRemoval(() -> {
            List<FormattedChatMessage> messages = this.chatHistoryContainer.getMessages(username);
            int count = messages.size();
            messages.forEach(message -> this.chatHistoryContainer.removeMessage(message.getId()));
            return count > 0;
        }, () -> new ChatHistoryRemoveByPlayerEvent(Constants.IDENTIFIER, username), callEvent) ? 1 : 0;
    }

    private boolean processRemoval(BooleanSupplier removalFunction, Supplier<ChatHistoryRemoveEvent> eventSupplier, boolean callEvent) {
        if (removalFunction.getAsBoolean()) {
            if (callEvent) {
                EventUtil.callEvent(eventSupplier.get(), this::sendChatHistory);
                return true;
            }
            this.sendChatHistory();
            return true;
        }
        return false;
    }

    private void sendChatHistory() {
        TextComponent filler = Component.empty();
        for (int i = 0; i < ((ChatSettings)this.chatSettings.get()).getHistory().getFillerSize(); ++i) {
            filler = filler.append((Component)Component.newline());
        }
        TextComponent finalFiller = filler;
        this.interactor.broadcast((Component)finalFiller, BroadcastTarget.PLAYERS);
        this.chatHistoryContainer.getMessages().forEach(this.chatBroadcaster::broadcast);
    }

    @Inject
    @Generated
    public ChatHistoryController(ChatHistoryContainerService chatHistoryContainer, Provider<ChatSettings> chatSettings, ChatBroadcaster chatBroadcaster, PlatformInteractor interactor) {
        this.chatHistoryContainer = chatHistoryContainer;
        this.chatSettings = chatSettings;
        this.chatBroadcaster = chatBroadcaster;
        this.interactor = interactor;
    }
}

