/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat.broadcast;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.input.container.PlayerContainerService;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.model.chat.ChatMessages;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.type.BroadcastTarget;
import me.whereareiam.socialismus.library.adventure.text.Component;
import me.whereareiam.socialismus.library.adventure.text.ComponentLike;
import me.whereareiam.socialismus.library.adventure.text.TextReplacementConfig;
import me.whereareiam.socialismus.library.adventure.text.event.ClickEvent;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ChatBroadcaster {
    private final PlayerContainerService playerContainer;
    private final Provider<ChatSettings> chatSettings;
    private final Provider<ChatMessages> chatMessages;
    private final Provider<Map<String, CommandEntity>> commands;

    public void broadcast(FormattedChatMessage chatMessage) {
        chatMessage.getSender().getInteractor().broadcast(chatMessage.getFormat().replaceText(this.createMessageReplacement(chatMessage.getContent())).replaceText(this.createClearReplacement(chatMessage, chatMessage.getSender().getUniqueId())), BroadcastTarget.CONSOLE);
        chatMessage.getRecipients().forEach(recipient -> recipient.sendMessage(chatMessage.getFormat().replaceText(this.createMessageReplacement(chatMessage.getContent())).replaceText(this.createClearReplacement(chatMessage, recipient.getUniqueId()))));
    }

    public TextReplacementConfig createMessageReplacement(Component component) {
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{message}").replacement((ComponentLike)component).build();
    }

    public TextReplacementConfig createClearReplacement(FormattedChatMessage formattedChatMessage, UUID recipientUniqueId) {
        DummyPlayer sender = formattedChatMessage.getSender();
        Optional<DummyPlayer> recipient = this.playerContainer.getPlayer(recipientUniqueId);
        if (recipient.isPresent() && recipient.get().hasPermission(((ChatSettings)this.chatSettings.get()).getHistory().getPermission()) && !sender.hasPermission(((ChatSettings)this.chatSettings.get()).getHistory().getBypassPermission())) {
            return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{clear}").replacement((ComponentLike)Serializer.serialize(sender, ((ChatMessages)this.chatMessages.get()).getClearFormat().getFormat()).clickEvent(ClickEvent.runCommand((String)("/" + ((CommandEntity)((Map)this.commands.get()).get("clear")).getUsage().replace("{command}", ((CommandEntity)((Map)this.commands.get()).get("main")).getAliases().get(0)).replace("{alias}", ((CommandEntity)((Map)this.commands.get()).get("clear")).getAliases().get(0)).replace("[context]", String.valueOf(formattedChatMessage.getId())))))).build();
        }
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{clear}").replacement((ComponentLike)Component.empty()).build();
    }

    @Inject
    @Generated
    public ChatBroadcaster(PlayerContainerService playerContainer, Provider<ChatSettings> chatSettings, Provider<ChatMessages> chatMessages, Provider<Map<String, CommandEntity>> commands) {
        this.playerContainer = playerContainer;
        this.chatSettings = chatSettings;
        this.chatMessages = chatMessages;
        this.commands = commands;
    }
}

