/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat.worker.base;

import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.WorkerProcessor;
import me.whereareiam.socialismus.api.input.container.PlayerContainerService;
import me.whereareiam.socialismus.api.input.event.chat.recipient.RecipientsResolvedEvent;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class RecipientResolver {
    private final PlayerContainerService playerContainer;

    @Inject
    public RecipientResolver(WorkerProcessor<ChatMessage> workerProcessor, PlayerContainerService playerContainer) {
        this.playerContainer = playerContainer;
        workerProcessor.addWorker(new Worker<ChatMessage>(this::resolveRecipients, 75, true, false));
    }

    private ChatMessage resolveRecipients(ChatMessage chatMessage) {
        if (!chatMessage.getRecipients().isEmpty()) {
            return chatMessage;
        }
        Logger.debug("Resolving recipients for chat message from %s", chatMessage.getSender().getUsername());
        EventUtil.callEvent(new RecipientsResolvedEvent(chatMessage, chatMessage.isCancelled()), () -> chatMessage.setRecipients(this.playerContainer.getPlayers()));
        return chatMessage;
    }
}

