/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat.worker.base;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.input.WorkerProcessor;
import me.whereareiam.socialismus.api.input.event.chat.recipient.RecipientsSelectedEvent;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.chat.Chat;
import me.whereareiam.socialismus.api.model.chat.ChatMessages;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.serializer.SerializerContent;
import me.whereareiam.socialismus.api.model.serializer.SerializerPlaceholder;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.type.chat.Participants;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.common.requirement.RequirementEvaluator;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class RecipientSelector {
    private final RequirementEvaluator requirementEvaluator;
    private final Provider<ChatSettings> settings;
    private final Provider<ChatMessages> messages;
    private final PlatformInteractor interactor;

    @Inject
    public RecipientSelector(WorkerProcessor<ChatMessage> workerProcessor, RequirementEvaluator requirementEvaluator, Provider<ChatSettings> settings, Provider<ChatMessages> messages, PlatformInteractor interactor) {
        this.requirementEvaluator = requirementEvaluator;
        this.settings = settings;
        this.messages = messages;
        this.interactor = interactor;
        workerProcessor.addWorker(new Worker<ChatMessage>(this::selectRecipients, 100, true, false));
    }

    private ChatMessage selectRecipients(ChatMessage chatMessage) {
        if (chatMessage.getChat() == null) {
            chatMessage.setCancelled(true);
            return chatMessage;
        }
        Chat chat = chatMessage.getChat();
        DummyPlayer sender = chatMessage.getSender();
        int oldRecipients = chatMessage.getRecipients().size();
        Set<DummyPlayer> recipients = chatMessage.getRecipients();
        if (chat.getParameters().getType().isLocal()) {
            if ((recipients = recipients.parallelStream().filter(recipient -> this.isInSameRealm(sender, (DummyPlayer)recipient)).filter(recipient -> this.isWithinRadius(sender, (DummyPlayer)recipient, chat.getParameters().getRadius())).filter(recipient -> this.checkRequirements(chat, (DummyPlayer)recipient)).collect(Collectors.toSet())).size() <= 1 && ((ChatSettings)this.settings.get()).isNotifyNoNearbyPlayers()) {
                sender.sendMessage(Serializer.serialize(new SerializerContent(sender, List.of(new SerializerPlaceholder("{radius}", String.valueOf(chat.getParameters().getRadius()))), ((ChatMessages)this.messages.get()).getNoNearbyPlayers())));
                chatMessage.setCancelled(true);
                return chatMessage;
            }
        } else {
            recipients = recipients.stream().filter(recipient -> this.checkRequirements(chat, (DummyPlayer)recipient)).collect(Collectors.toSet());
        }
        RecipientsSelectedEvent event = new RecipientsSelectedEvent(chatMessage, recipients, chatMessage.isCancelled());
        EventUtil.callEvent(event, () -> chatMessage.setRecipients(event.getNewRecipients()));
        Logger.debug("Recipients before: " + oldRecipients + ", after: " + event.getNewRecipients().size(), new Object[0]);
        if (recipients.isEmpty()) {
            chatMessage.setCancelled(true);
        }
        if (recipients.size() <= 1 && ((ChatSettings)this.settings.get()).isNotifyNoPlayers() && chat.getParameters().getType().isGlobal()) {
            sender.sendMessage(Serializer.serialize(sender, ((ChatMessages)this.messages.get()).getNoPlayers()));
            chatMessage.setCancelled(true);
        }
        return chatMessage;
    }

    private boolean checkRequirements(Chat chat, DummyPlayer dummyPlayer) {
        return this.requirementEvaluator.check(chat.getRequirements().get((Object)Participants.RECIPIENT), dummyPlayer);
    }

    private boolean isInSameRealm(DummyPlayer sender, DummyPlayer recipient) {
        return recipient.getLocation().equals(sender.getLocation());
    }

    private boolean isWithinRadius(DummyPlayer sender, DummyPlayer recipient, double radius) {
        return this.interactor.areWithinRange(sender.getUniqueId(), recipient.getUniqueId(), radius);
    }
}

