/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat.worker.formatted;

import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.input.WorkerProcessor;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.chat.ChatFormat;
import me.whereareiam.socialismus.api.model.chat.ChatMessages;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.type.chat.Participants;
import me.whereareiam.socialismus.common.requirement.RequirementEvaluator;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class FormatSelector {
    private final RequirementEvaluator requirementEvaluator;
    private final Provider<ChatMessages> chatMessages;
    private final Provider<ChatSettings> chatSettings;

    @Inject
    public FormatSelector(WorkerProcessor<FormattedChatMessage> workerProcessor, RequirementEvaluator requirementEvaluator, Provider<ChatMessages> chatMessages, Provider<ChatSettings> chatSettings) {
        this.requirementEvaluator = requirementEvaluator;
        this.chatMessages = chatMessages;
        this.chatSettings = chatSettings;
        chatMessages.get();
        workerProcessor.addWorker(new Worker<FormattedChatMessage>(this::formatChat, 0, true, false));
    }

    private FormattedChatMessage formatChat(FormattedChatMessage msg) {
        Logger.debug("Formatting chat message for user " + msg.getSender().getUsername(), new Object[0]);
        ChatFormat chosen = this.selectFormat(msg);
        if (chosen == null) {
            this.notifyAboutAbsentFormat(msg);
            msg.setCancelled(true);
            return msg;
        }
        Logger.debug("Selected format: " + String.valueOf(chosen), new Object[0]);
        msg.setFormat(Serializer.serialize(msg.getSender(), chosen.getFormat()));
        return msg;
    }

    private ChatFormat selectFormat(FormattedChatMessage msg) {
        for (ChatFormat format : msg.getChat().getFormats().reversed()) {
            if (!this.isAllowed(format, msg)) continue;
            return format;
        }
        return null;
    }

    private boolean isAllowed(ChatFormat format, FormattedChatMessage msg) {
        if (format.getRequirements() == null) {
            return true;
        }
        if (format.getRequirements().get((Object)Participants.SENDER) == null) {
            return true;
        }
        return this.requirementEvaluator.check(format.getRequirements().get((Object)Participants.SENDER), msg.getSender());
    }

    private void notifyAboutAbsentFormat(FormattedChatMessage msg) {
        if (!((ChatSettings)this.chatSettings.get()).isNotifyNoFormat()) {
            return;
        }
        msg.getSender().sendMessage(Serializer.serialize(msg.getSender(), ((ChatMessages)this.chatMessages.get()).getNoChatMatch()));
    }
}

