/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.whereareiam.socialismus.api.input.container.ChatHistoryContainerService;
import me.whereareiam.socialismus.api.input.event.chat.history.MessageAddedEvent;
import me.whereareiam.socialismus.api.input.event.chat.history.MessageRemovedEvent;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ChatHistoryContainer
implements ChatHistoryContainerService {
    private final Map<Integer, FormattedChatMessage> chatHistory;

    @Inject
    public ChatHistoryContainer(final Provider<ChatSettings> chatSettings) {
        this.chatHistory = new LinkedHashMap<Integer, FormattedChatMessage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, FormattedChatMessage> eldest) {
                return this.size() > ((ChatSettings)chatSettings.get()).getHistory().getHistorySize();
            }
        };
    }

    @Override
    public void addMessage(int id, FormattedChatMessage message) {
        EventUtil.callEvent(new MessageAddedEvent(message, message.isCancelled()), () -> this.chatHistory.put(id, message));
    }

    @Override
    public boolean removeMessage(int id) {
        FormattedChatMessage chatMessage = this.chatHistory.get(id);
        return EventUtil.callEvent(new MessageRemovedEvent(chatMessage, chatMessage.isCancelled()), () -> this.chatHistory.remove(id));
    }

    @Override
    public int removeMessages(int amount) {
        int removed = 0;
        Iterator<Map.Entry<Integer, FormattedChatMessage>> iterator = this.chatHistory.entrySet().iterator();
        while (iterator.hasNext() && removed < amount) {
            Map.Entry<Integer, FormattedChatMessage> entry = iterator.next();
            FormattedChatMessage chatMessage = entry.getValue();
            if (!EventUtil.callEvent(new MessageRemovedEvent(chatMessage, chatMessage.isCancelled()), iterator::remove)) continue;
            ++removed;
        }
        return removed;
    }

    @Override
    public Optional<FormattedChatMessage> getMessage(int id) {
        return this.chatHistory.containsKey(id) ? Optional.of(this.chatHistory.get(id)) : Optional.empty();
    }

    @Override
    public List<FormattedChatMessage> getMessages(String username) {
        return this.chatHistory.values().parallelStream().filter(message -> message.getSender().getUsername().equals(username)).toList();
    }

    @Override
    public List<FormattedChatMessage> getMessages(UUID uniqueId) {
        return this.chatHistory.values().parallelStream().filter(message -> message.getSender().getUniqueId().equals(uniqueId)).toList();
    }

    @Override
    public List<FormattedChatMessage> getMessages() {
        return new ArrayList<FormattedChatMessage>(this.chatHistory.values());
    }
}

