/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.printer;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import me.whereareiam.socialismus.api.AnsiColor;
import me.whereareiam.socialismus.api.output.LoggingHelper;
import me.whereareiam.socialismus.api.output.command.CommandService;
import me.whereareiam.socialismus.api.output.resource.ResourceRegistry;
import me.whereareiam.socialismus.api.type.PlatformType;
import me.whereareiam.socialismus.api.type.PluginType;
import me.whereareiam.socialismus.api.type.ResourceType;
import me.whereareiam.socialismus.common.container.ChatContainer;
import me.whereareiam.socialismus.common.provider.IntegrationProvider;
import me.whereareiam.socialismus.library.guice.Inject;

public class WelcomeBannerPrinter {
    private final LoggingHelper loggingHelper;
    private final CommandService commandService;
    private final ChatContainer chatContainer;
    private final IntegrationProvider integrationProvider;
    private final ResourceRegistry resourceRegistry;

    public void print() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(this.buildTitleLines());
        lines.addAll(this.buildStatsLines());
        lines.addAll(this.buildIntegrationLines());
        lines.addAll(this.buildConnectionLines());
        lines.forEach(x$0 -> this.loggingHelper.info((String)x$0, new Object[0]));
    }

    private List<String> buildTitleLines() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("");
        l.add(String.valueOf((Object)AnsiColor.CYAN) + "  \u2588\u2580\u2003\u2588\u2580\u2580   " + String.valueOf((Object)AnsiColor.RESET) + "Socialismus v" + String.valueOf((Object)AnsiColor.GRAY) + "2.0.0-RC4" + String.valueOf((Object)AnsiColor.RESET));
        l.add(String.valueOf((Object)AnsiColor.CYAN) + "  \u2584\u2588\u2003\u2588\u2584\u2584   " + String.valueOf((Object)AnsiColor.RESET) + "Platform: " + String.valueOf((Object)AnsiColor.GRAY) + String.valueOf((Object)PlatformType.getType()) + " [" + String.valueOf((Object)PluginType.getType()) + "]" + String.valueOf((Object)AnsiColor.RESET));
        l.add("");
        return l;
    }

    private List<String> buildStatsLines() {
        ArrayList<String> l = new ArrayList<String>();
        int cmdCount = this.commandService.getCommandCount();
        int chatCount = this.chatContainer.getChats().size();
        l.add("  Loaded " + String.valueOf((Object)AnsiColor.CYAN) + cmdCount + String.valueOf((Object)AnsiColor.RESET) + " command" + (cmdCount == 1 ? "" : "s"));
        l.add("  Loaded " + String.valueOf((Object)AnsiColor.CYAN) + chatCount + String.valueOf((Object)AnsiColor.RESET) + " chat" + (chatCount == 1 ? "" : "s"));
        l.add("");
        return l;
    }

    private List<String> buildIntegrationLines() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("  Integrations:");
        this.integrationProvider.get().forEach(i -> l.add("    - " + String.valueOf((Object)AnsiColor.GREEN) + i.getName() + String.valueOf((Object)AnsiColor.RESET)));
        l.add("");
        return l;
    }

    private List<String> buildConnectionLines() {
        ArrayList<String> l = new ArrayList<String>();
        boolean db = this.resourceRegistry.has(ResourceType.DATABASE);
        boolean sync = this.resourceRegistry.has(ResourceType.SYNC);
        boolean cache = this.resourceRegistry.has(ResourceType.CACHE);
        if (db || sync || cache) {
            l.add("  Connections:");
            if (db) {
                l.add(this.formatConn("Database"));
            }
            if (sync) {
                l.add(this.formatConn("Synchronization"));
            }
            if (cache) {
                l.add(this.formatConn("Cache"));
            }
            l.add("");
        }
        return l;
    }

    private String formatConn(String label) {
        return String.format("    - %s%s%s", new Object[]{AnsiColor.GREEN, label, AnsiColor.RESET});
    }

    @Inject
    @Generated
    public WelcomeBannerPrinter(LoggingHelper loggingHelper, CommandService commandService, ChatContainer chatContainer, IntegrationProvider integrationProvider, ResourceRegistry resourceRegistry) {
        this.loggingHelper = loggingHelper;
        this.commandService = commandService;
        this.chatContainer = chatContainer;
        this.integrationProvider = integrationProvider;
        this.resourceRegistry = resourceRegistry;
    }
}

