/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.requirement.validation;

import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.registry.ExtendedRegistry;
import me.whereareiam.socialismus.api.input.requirement.RequirementValidation;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.requirement.Requirement;
import me.whereareiam.socialismus.api.model.requirement.type.ChatRequirement;
import me.whereareiam.socialismus.api.type.PlatformType;
import me.whereareiam.socialismus.api.type.requirement.RequirementType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ChatRequirementValidation
implements RequirementValidation {
    @Inject
    public ChatRequirementValidation(ExtendedRegistry<RequirementType, RequirementValidation> registry) {
        registry.register(RequirementType.CHAT, this);
    }

    @Override
    public boolean check(Requirement requirement, DummyPlayer dummyPlayer) {
        String[] expectedValues;
        if (!(requirement instanceof ChatRequirement)) {
            return false;
        }
        ChatRequirement cr = (ChatRequirement)requirement;
        if (!PlatformType.isGameServer()) {
            return false;
        }
        Logger.debug("Checking chat requirement for player " + dummyPlayer.getUsername(), new Object[0]);
        boolean checkResult = false;
        switch (cr.getCondition()) {
            case EQUALS: {
                checkResult = cr.getChatIdentifiers().size() == 1 && cr.getChatIdentifiers().get(0).equals(dummyPlayer.getLastChat() != null ? dummyPlayer.getLastChat().getId() : "null");
                break;
            }
            case CONTAINS: {
                checkResult = cr.getChatIdentifiers().contains(dummyPlayer.getLastChat() != null ? dummyPlayer.getLastChat().getId() : "null");
            }
        }
        for (String expectedValue : expectedValues = cr.getExpected().split("\\|")) {
            if (!String.valueOf(checkResult).equals(expectedValue)) continue;
            Logger.debug("Found matching expected value: " + checkResult + " for player " + dummyPlayer.getUsername(), new Object[0]);
            return true;
        }
        Logger.debug("No matching expected values found for player " + dummyPlayer.getUsername(), new Object[0]);
        return false;
    }
}

