/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.sync;

import java.util.Set;
import lombok.Generated;
import me.whereareiam.socialismus.api.Constants;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.sync.ChatSyncBus;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.output.SerializationService;
import me.whereareiam.socialismus.api.output.resource.sync.SyncService;
import me.whereareiam.socialismus.common.chat.ChatCoordinator;
import me.whereareiam.socialismus.library.adventure.text.Component;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ChatNetworkBridge
implements ChatSyncBus {
    private static final String CHANNEL = "socialismus:chat";
    private final SyncService sync;
    private final SerializationService serializationService;
    private final ChatCoordinator coordinator;
    private final PlatformInteractor platformInteractor;
    private final Provider<ChatSettings> chatSettings;
    private final Component emptyComponent = Component.empty();

    public void initialize() {
        if (!((ChatSettings)this.chatSettings.get()).getSynchronization().isEnabled()) {
            return;
        }
        this.subscribe();
    }

    @Override
    public void publish(FormattedChatMessage message) {
        if (!((ChatSettings)this.chatSettings.get()).getSynchronization().isEnabled()) {
            return;
        }
        try {
            message.setOrigin(Constants.IDENTIFIER);
            byte[] data = this.serializationService.serialize(message);
            this.sync.publish(CHANNEL, data);
            Logger.debug("Published chat message to sync channel: " + message.getId(), new Object[0]);
        }
        catch (Exception ex) {
            Logger.warn("Failed to sync chat message: " + String.valueOf(ex), new Object[0]);
        }
    }

    @Override
    public void subscribe() {
        if (!((ChatSettings)this.chatSettings.get()).getSynchronization().isEnabled()) {
            return;
        }
        this.sync.subscribe(CHANNEL, (channel, payload) -> this.handleEvent(payload));
    }

    private void handleEvent(byte[] payload) {
        try {
            FormattedChatMessage message = this.serializationService.deserialize(payload, FormattedChatMessage.class);
            if (Constants.IDENTIFIER.equals(message.getOrigin())) {
                return;
            }
            message.setRecipients(Set.of());
            message.getSender().setInteractor(this.platformInteractor);
            if (message.getFormat() != null && !message.getFormat().equals((Object)this.emptyComponent) && ((ChatSettings)this.chatSettings.get()).getSynchronization().isPreserveFormat()) {
                this.coordinator.coordinate(message);
                return;
            }
            this.coordinator.coordinate((ChatMessage)message);
        }
        catch (Exception ex) {
            Logger.warn("Bad chat-sync packet: " + String.valueOf(ex), new Object[0]);
        }
    }

    @Inject
    @Generated
    public ChatNetworkBridge(SyncService sync, SerializationService serializationService, ChatCoordinator coordinator, PlatformInteractor platformInteractor, Provider<ChatSettings> chatSettings) {
        this.sync = sync;
        this.serializationService = serializationService;
        this.coordinator = coordinator;
        this.platformInteractor = platformInteractor;
        this.chatSettings = chatSettings;
    }
}

